-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
member_window:  USING (events, times )
-- interface between member type 1 and its front-end process
DEFINITIONS

-- Window -> Member calls:
	Plan_Appt : callmessage (
		Desired_Times : Time_Set,
		Desired_Participants : Member_IDs,
		Uncontacted_Participants : Member_IDs, -- Set by the Scheduler
		-- Times when all Participants contacted are found to be available
		Available_Times : Time_Set )
		constant( Desired_Times, Desired_Participants )
		exit {full};
	Plan_Appt_In : inport of Plan_Appt
		 {full(Desired_Times), full(Desired_Participants) };
	Plan_Appt_Out : outport of Plan_Appt_In;
--  Idea: an exception that not all participants contacted.

	Schedule_Appt : callmessage (
		Time: Time_range,
		Expected_Participants : Member_IDs, -- if just self, then only goes in personal apptments calendar
		Annotation: charstring,
		Location: charstring,
		Conflict_P: boolean, -- true if this isn't really an appointment
		Unscheduled_Participants : Member_IDs)
		constant( Time, Expected_Participants, Annotation, Location, Conflict_P )
		exit {full(Time), full(Expected_Participants), full(Annotation), full(Location), full(Conflict_P)}
		exception Not_Scheduled{full(Time), full(Expected_Participants), full(Annotation), full(Location), full(Conflict_P), full(Unscheduled_Participants)};
	Schedule_Appt_In : inport of Schedule_Appt 
		{full(Time), full(Expected_Participants), full(Annotation), full(Location), full(Conflict_P) };
	Schedule_Appt_Out : outport of Schedule_Appt_In;

	-- This cancels the event for everyone but is only done if the member
	-- receiving it organized the appointment
	Cancel_Appt : callmessage (  
		The_appt : Event_ID , -- The event's ID
		Reason: Charstring  -- why cancel didn't work
		)
		constant( The_appt )
		exit {full(The_appt)}
		exception Not_Cancelled {full};
	Cancel_Appt_In : inport of Cancel_Appt {full(The_appt)}; 
	Cancel_Appt_Out : outport of Cancel_Appt_In;

	List_Appts : callmessage (
		Calendar_Period : Time_Range,
		Appointments : Table_Of_Events )
		constant( Calendar_Period )
		exit {full};
	List_Appts_In : inport of List_Appts { full(Calendar_Period) };
	List_Appts_Out : outport of List_Appts_In;
	
	List_Members: callmessage (
	        TheMembers: Members
	        )
	        constant()
	        exit {full};
        List_Members_In: inport of List_Members {};
        List_Members_Out: outport of List_Members_In;
        
-- calls from the member type 1 to the front-end
        Notify_Appt: callmessage(
                NewEvent: An_Event, -- event which someone else scheduled/cancelled
                WhatHappened: ScheduledOrCancelled -- whether it was scheduled or cancelled
                )
                constant (NewEvent, WhatHappened)
                exit {full};
        Notify_Appt_In : inport of Notify_Appt {full};
        Notify_Appt_Out: outport of Notify_Appt_In;

        ScheduledOrCancelled: enumeration ('scheduled', 'cancelled');

end DEFINITIONS
