-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
make_ac_filtered: using(rManager, ac_filtered, common, terminalio)  process (init: make_ac_filtered_initIn)
    -- access control which unconditionally gives access to resource as is
  declare
    parms: make_ac_filtered_init;
    unauthorized: charstringList; -- who can't access
    notify: putStringFunc; -- whom to tell if badguy tries
    ac: accessQ; -- ac port
    accm: access; -- access request
    makefilter: bbfilter_initOut; -- procedure to make a filter
    bb: putStringFunc; -- the real putstring 
    fbb: putstringFunc; -- the filtered putstring
  begin
    receive parms from init;
    unauthorized := parms.unauthorized;
    notify := parms.notify;
    new ac;
    connect parms.ac to ac;
    makefilter <- procedure of process (init: bbfilter_initIn)
      declare
        parms: bbfilter_init;
        fbb: putStringQ;
        username: charstring;
        bb: putStringFunc;
        cm: putStringIntf;
      begin
        receive parms from init;
        username := parms.username;
        bb := parms.bb;
        new fbb; connect parms.fbb to fbb;
        return parms;
        while ('true')
          repeat
            receive cm from fbb;
            call bb(username | ":" | cm.string);
            return cm;
          end while;
      end process ;
    return parms;
    while ('true') 
      repeat
        receive accm from ac;
        BLOCK
          BEGIN
            if exists of user in unauthorized where(user = accm.username)
              then
                call notify(accm.username| " tried to access BB, but is unauthorized");
                return accm exception AccessDenied;
              else
                unwrap bb from copy of accm.postedResource {init};
                call makefilter(bb, accm.username, fbb);
                wrap copy of fbb as accm.resource;
                return accm; 
              end if;
          on (others)
            call notify("Others exception trying to authorize "|accm.username);	
          END BLOCK;
      end while;
  end process
