-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: comp_times.p
-- Author: Arthur P. Goldberg

-- a call
-- call comp_times ( Input_Time_Value_1, Input_Time_Value_2, Boolean_Return);

-- Boolean_Return = 'true'  <=> Input_Time_Value_1 < Input_Time_Value_2

comp_times : USING( times, terminalIO )
LINKING()

PROCESS ( Call_Port : Time_Value_Call2_Return_Boolean_INTFACE_Receiver )
	DECLARE
		TCM : Time_Value_Call2_Return_Boolean_INTFACE;
	BEGIN
		RECEIVE TCM FROM Call_Port;
		-- print charstring # "On entry to Time_Value_Max TCM: ";
		-- call init.std.terminal.putline(TCM);
		-- print TCM;

		if ( TCM.Input_Time_Value_1 = TCM.Input_Time_Value_2 ) then
			TCM.Boolean_Return := 'false';
			exit done;
		end if;

		if ( case of TCM.Input_Time_Value_1 = 'An_Infinity' ) then
			reveal TCM.Input_Time_Value_1.The_Infinity;
			if ( TCM.Input_Time_Value_1.The_Infinity = 'Neg_Inf' ) then
				TCM.Boolean_Return := 'true';
			else
				-- Input_Time_Value_1 is 'Pos_Inf'
				TCM.Boolean_Return := 'false';
			end if;
			exit done;
		end if;

		if ( case of TCM.Input_Time_Value_2 = 'An_Infinity' ) then
			reveal TCM.Input_Time_Value_2.The_Infinity;
			if ( TCM.Input_Time_Value_2.The_Infinity = 'Neg_Inf' ) then
				TCM.Boolean_Return := 'false';
			else
				-- Input_Time_Value_2 is 'Pos_Inf'
				TCM.Boolean_Return := 'true';
			end if;
			exit done;
		end if;

		-- Both Input_Time_Value_1 and Input_Time_Value_2 are 'Actual'
		if ( case of TCM.Input_Time_Value_1 = 'Actual' and 
			case of TCM.Input_Time_Value_2 = 'Actual' ) then
			reveal TCM.Input_Time_Value_1.The_Actual_Time;
			reveal TCM.Input_Time_Value_2.The_Actual_Time;
			if ( TCM.Input_Time_Value_1.The_Actual_Time < TCM.Input_Time_Value_2.The_Actual_Time ) then
				TCM.Boolean_Return := 'true';
			else
				TCM.Boolean_Return := 'false';
			end if;
			exit done;
		end if;

		on exit (done)
			return TCM;
end process
