-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: union_time_ranges.p
-- Author: Arthur P. Goldberg

-- find the union of two time ranges
-- call union_time_ranges( Input_Time_Range_1, Input_Time_Range_2,
-- Output_Time_Range_1, Output_Time_Range_2 );

-- Algorithm:
-- if ( Max_Begin_Time <= Min_End_Time ) then
	-- Output_Time_Range_1 := [ Min_Begin, Max_End )
	-- Output_Time_Range_2 := Never
-- else
	-- Output_Time_Range_1 := Input_Time_Range_1 
	-- Output_Time_Range_2 := Input_Time_Range_2
-- end if

union_time_ranges: USING( times, terminalIO )
LINKING( Min_Time, Max_Time, Comp_Times )

PROCESS ( Call_Port : Time_Range_In2_Out2_Procedure_Receiver )
	DECLARE
		TCM : Time_Range_In2_Out2_INTFACE;
		Max_Begin_Time : Time_Value;
		Min_End_Time : Time_Value;
		Min_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Max_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Comp_Times : Time_Value_Call2_Return_Boolean_INTFACE_Caller;
	BEGIN
		RECEIVE TCM FROM Call_Port;

  		Min_Time <- procedure of process min_time; 
  		Max_Time <- procedure of process max_time;
		Comp_Times <- procedure of process comp_times; 

		Max_Begin_Time := Max_Time (TCM.Input_Time_Range_1.Begin_Time, 
			TCM.Input_Time_Range_2.Begin_Time);

		Min_End_Time := Min_Time (TCM.Input_Time_Range_1.End_Time, 
			TCM.Input_Time_Range_2.End_Time);

		new TCM.Output_Time_Range_1;
		new TCM.Output_Time_Range_2;

		-- ( Max_Begin_Time <= Min_End_Time )  <=>
		-- not( Max_Begin_Time > Min_End_Time )  <=>
		-- not( Comp_Times( Min_End_Time, Max_Begin_Time )) 
		if ( not( Comp_Times( Min_End_Time, Max_Begin_Time ))) then 

			TCM.Output_Time_Range_1.Begin_Time := 
				Min_Time (TCM.Input_Time_Range_1.Begin_Time, 
				TCM.Input_Time_Range_2.Begin_Time);
			TCM.Output_Time_Range_1.End_Time := 
				Max_Time (TCM.Input_Time_Range_1.End_Time, 
				TCM.Input_Time_Range_2.End_Time);

			-- would prefer to have a constant time range called 'Never'
			unite TCM.Output_Time_Range_2.Begin_Time.The_Infinity from 'Pos_Inf';
			unite TCM.Output_Time_Range_2.End_Time.The_Infinity from 'Pos_Inf';
		else

			TCM.Output_Time_Range_1 := TCM.Input_Time_Range_1;
			TCM.Output_Time_Range_2 := TCM.Input_Time_Range_2;
		end if;

		return TCM;

end process
