/* (C) Copyright International Business Machines Corporation 5 December */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */

/* Filename: crtoa.ch */
/* Author: William Silverman */
static char sccsInfo[] = "@(#)crtoa.ch	1.4 3/15/92";

#include <stdio.h>

#include "cfunc.h"
#include "crtoa.cd"
#include "interpform.cd"

CProc(C_crtoa)
{
  lobject(CMsg);
  objectp Initp;

  int field, precision, n;
  char stop, spec, dummy;
  char *f;
  char *strcat();

  char rs[512];
  char fmt[16];

  Initp = & current->ep.c->initport;

  copy(CMsg, Bottom);
  if (c_receive(CMsg, Initp) is SUCCESS) {
    f = stringval(CMsg@convertrealtoascii__format);
    if ( (n = sscanf(f, "%d%c%c", &field, &spec, &dummy)) != 2 ) {
      if ( n = 3 && '0' <= dummy && dummy <= '9' ) {
	if ( sscanf(f, "%d%c%d%c%c", &field, &stop, &precision, &spec, &dummy )
	       != 4 ||
	     stop != '.' || precision > 128
	   ) spec = '?';
      }
      else {
	field = 0;
	if ( strlen(f) == 1 )
	  spec = f[0];
	else
	  spec = '?';
      }
    }
    if ( strlen(f) > 14 || field > 256 || field < -256 ||
	 (spec != 'e'  && spec != 'f' && spec != 'g')
       )
      f = "e";
    fmt[0] = '%'; fmt[1] = 0;
    f = strcat(fmt, f);
    sprintf(rs, fmt, *((CMsg@convertrealtoascii__real)->value.real));
    if (!chs_lit(CMsg@convertrealtoascii__string, rs))
      c_discard(sched, CMsg);
    else
      c_return(sched, CMsg);
  }
  else if (c_disconn(Initp)) {
    c_discard(sched, Initp);
    c_endprocess(sched, current);
  }
  else
    c_wait(sched, current, Initp); /* wait for next request */
  return;

}
