-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- Hermes structures for representing C datatypes
-- Andy Lowry & David F. Bacon, Apr 1989

-- SCCS Info: @(#)ctype.d	1.2 3/13/90

-- note: C's concept of a "type" corresponds to a type reference
-- note on note: the above written by dfb... don't ask me what he
--   means by it! (arl) 

cType: using (predefined)
definitions

  -- A C type can either be a base type with qualifiers (not the same
  -- as a primitive type) or derived type
  cType: variant of typeType (
    'Base' -> qualifiedType: qualifiedType {full},
    'Derived' -> derivedType: derivedType { full }
  );
  typeType: enumeration ( 'Base', 'Derived' );

  -- A base type with its qualifiers and associated info if any
  qualifiedType: record (
    qualifiers: cQualifiers,
    type: baseTypeSpec
  );
    
  -- Basic types, including primitives, constructors, and named
  -- types defined via C's typedef
  baseType: enumeration (
    'void',			-- primitive types
    'char',
    'int',
    'float',
    'double',
    'struct',			-- constructor types
    'union',
    'enum',
    'typedef'			-- named types
  );

  -- A baseTypeSpec specifies one of the base type categories, and for
  -- constructors and named types, associates a name by which detailed
  -- information can be looked up
  baseTypeSpec: variant of baseType (
    'void' -> void: empty {},
    'char' -> char: empty {},
    'int' -> int: empty {},
    'float' -> float: empty {},
    'double' -> double: empty {},
    'struct' -> struct: charstring {init},
    'union' -> union: charstring {init},
    'enum' -> enum: charstring {init},
    'typedef' -> typedef: charstring {init}
  );

  -- A derived type builds on an arbitrary type that serves as its base
  derivedType: record (
    base: cType,
    info: derivedTypeSpec
  );

  -- A derivedTypeSpec specifies one of the type derivation mechanisms
  -- and supplies any associated info
  derivedTypeSpec: variant of derivationType (
    'Pointer' -> pointerInfo: empty {},
    'Function' -> functionInfo: empty {},
    'Array' -> arrayInfo: optInteger { init }
				-- array size... 3 for "int x[3]",
				-- absent for "int x[]"
  );

  -- all the ways of turning a type into another type
  derivationType: enumeration (
    'Pointer',			-- pointer to a type
    'Array',			-- array with elements of a type
    'Function'			-- function returning a type
  );


  -- qualifiers on basic types; not all qualifiers apply to all types
  cQualifier: enumeration (
    'short',
    'long',
    'unsigned',
    'extern',
    'auto',
    'static',
    'register'
  );

  cQualifiers: table of cQualifier -- a collection of the above
    {full};

  optInteger: variant of option (
    'present' -> integer: integer {full},
    'absent' -> empty: empty {}
  );

end definitions
