/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)readobject.ch	1.7 8/28/91";
#endif

#include <stdio.h>
#include "cfunc.h"

#include "objectio.cd"
#include "predefined.cd"

extern datarep dr_polymorph;

CProc(C_readobject)
{
    lobject(CMsg);
    lobject(Readobj);
    objectp Initp;
    int ok = TRUE;

    Initp = & current->ep.c->initport;

    (void) copy(CMsg, Bottom);
    if (c_receive(CMsg, Initp) is SUCCESS) {

	if (read(Readobj, CMsg@readobject_intf__filename) isnt Normal)
	    ok = FALSE;
	else {
	    if (Readobj->tsdr is &dr_polymorph) {
          *CMsg@readobject_intf__object = *Readobj;
#ifdef DEBUG
          if (debug_level(1) and
              Readobj->value.polymorph->obj.tsdr is &dr_program) {
            objectp prog;
            
            prog = &(Readobj->value.polymorph->obj);
            /* prog@program__definitions_modules 
               = dot(prog, program__definitions_modules)
               = &(prog->value.record->data[program__definitions_modules]) 
               */
            if ((prog@program__definitions_modules)->tsdr is &dr_bottom)
              (void) fprintf(stderr, "readobject.ch read a program object with uninitialized definitions_modules\n");
            if ((prog@program__main_program)->tsdr is &dr_bottom)
              (void) fprintf(stderr, "readobject.ch read a program object with uninitialized main_program\n");
            if ((prog@program__programs)->tsdr is &dr_bottom)
              (void) fprintf(stderr, "readobject.ch read a program object with uninitialized programs\n");
          }
#endif DEBUG

        }
        else {	/* should never happen */
          nilerror("C_readobject", "bare object");
          if (wrap(CMsg@readobject_intf__object, Readobj, nil)
              isnt Normal
              )
		    ok = FALSE;
	    }
	}

	if (ok)
	    c_return(sched, CMsg);
	else {
	    /* something failed */
	    (void) print(CMsg@readobject_intf__filename);
	    c_discard(sched, CMsg); /* should return_exception */
	}
    }

    else if (c_disconn(Initp)) {
      c_discard(sched, Initp);
      c_endprocess(sched,current);
    }
    else
      c_wait(sched, current, Initp); /* wait for the next request */
}
