-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_select.p	1.1 1/21/92

chimprove_select: using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: peeperQ)
    
  declare
    
    cm: peeper;
    
    sxsx: integer;
    spx: integer;
    stx: integer;
    st: ch_statement;
    opxs: operand_index_list;
    int: integer;
    ints: select_qual;
    op: ch_operand;
    sox: integer;
    src: integer;
    dst: integer;
    lit: qualifier_literal;
    i: integer;
    
  begin
    
    receive cm from Q;
    
    sxsx <- size of cm.sxs - 1;
    stx <- cm.sxs[sxsx];
    inspect st1 in cm.statements[stx] begin
	opxs := st1.operands;
	reveal st1.qualifier.select;
	ints := st1.qualifier.select;
	block begin
	    while sxsx > 0 repeat
		sxsx <- sxsx - 1;
		spx <- cm.sxs[sxsx];
		inspect st2 in cm.statements[spx] begin
		    inspect de in cm.ch.descriptors[st2.opcode] begin
			if de.choose <> 'compare' then
			    exit done;
			  end if;
		      end inspect;
		    if case of st2.qualifier = 'absent' then
			dst <- st2.operands[0];
			-- done if NotFound exception
			i <- position of ix in opxs where(ix = dst) - 1;
			remove int from ints[i/2];
			remove src from opxs[i];
			remove src from opxs[i];
			remove st from cm.statements[spx];
			unite st.qualifier.integer from int;
			insert st into cm.statements at spx;
			remove op from cm.operands[dst];
			op.Assignments <- op.Assignments - 1;
			op.References <- op.References - 2;
			insert op into cm.operands at dst;
		      end if;
		    if st2.references <> 0 then
			-- cant continue across join
			exit done;
		      end if;
		  end inspect;
	      end while;
	  on (NotFound)
	  on exit(done)
	  end block;
	if size of opxs = 0 then
	    exit drop;
	  end if;
	if opxs <> st1.operands then
	    remove st from cm.statements[stx];
	    st.operands <- opxs;
	    unite st.qualifier.select from ints;
	    insert st into cm.statements at stx;
	  end if;
      end inspect;
    
    return cm;
    
  on exit(drop)
    return cm exception drop;
  end process

