-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chinternal.d	1.3 2/17/92

chinternal: using(annotate, chdescriptors, common, crtoa, interpform, root,
  load, objectio, putfile, getfile, string, terminalIO, stdio, rmanager, unix)

definitions
  
  chcontrols : record(
    main : charstring,			-- module name
    names: charstringSet,		-- names chosen for progs so far
    modifier : integer,			-- uniquifier
    load : load_func,			-- so modules can load each other
    put : putStringFunc,		-- (for remarks)
    putfile : putfileFunc,		-- to write the Ccode file
    getfile: getfileFunc,		-- to read files
    access: fileAccessFn,		-- to see whether files exist
    runCmd: popenFn,			-- to run the compiler
    options : choptions,		-- options for chcode
    configuration: annotations,		-- strings from the config file
    descriptors : statement_descriptors,-- from chdescriptors.ho
    itoa : int2stringFn,		-- integer to string
    rtoa : formatrealFn			-- real to string
  );
  
  
  choptions: record (			-- options used by various modules
    verbose: boolean,			-- say what's going on
    quiet: boolean,			-- say very little
    comment: boolean,			-- include them in c code
    poLoader: load_func,		-- used to load .po files
    storepath: charstring,		-- where to put transformed .po files
    fullpaths: boolean,			-- use them in program path components
    keepC: boolean,			-- store c code in program object
    keepObj: boolean,			-- store object code in prog obj
    storeC: boolean,			-- write C code to file
    storeCPath: charstring,		-- where to put C files if storeC
    storeObj: boolean,			-- write object code to file
    storeObjPath: charstring,		-- where to write obj files if storeObj
    transform: boolean,			-- whether to transform code
    interpret: charstringList,		-- opcodes to leave interpreted
    debug: debugOptions,		-- types of debugging output needed
    compileCmd: compileCmdFn,		-- fills in compile cmd for a module
    configFile: charstring		-- path to chcode configuration file
  );
      
  debugOptions: table of charstring {init} keys (*);

  compileCmd: callmessage (
    entry: charstring,			-- entry point name
    source: charstring,			-- full path of C source file
    object: charstring,			-- full path of desired object file
    cmds: charstringList		-- commands to be run (output)
  )
  constant (entry, source, object)
  exit {full};
  compileCmdQ: inport of compileCmd
      {init(entry), init(source), init(object)};
  compileCmdFn: outport of compileCmdQ;
  
  initCompileCmd: callmessage (
    template: charstring,		-- string to be instantiated
    configuration: annotations,		-- configuration file values
    environ: environ,			-- environment variables
    compileCmd: compileCmdFn		-- function to do instantiating
  )
  constant (template, configuration, environ)
  exit {full};
  initCompileCmdQ: inport of initCompileCmd 
      {init(template), init(configuration), init(environ)};
  initCompileCmdFn: outport of initCompileCmdQ;
  
  getChOptions: callmessage (
    argv: charstringList,		-- in: cmd line args, out: non-options
    rm: rmanager,			-- resource manager
    options: choptions,			-- out: filled in options
    configuration: annotations		-- out: filled in config parameters
  )
  constant (rm)
  exit {full};
  getChOptionsQ: inport of getChOptions {init(argv), full(rm)};
  getChOptionsFn: outport of getChOptionsQ;

  getChConfiguration: callmessage (
    filename: charstring,		-- name of file to open
    environ: environ,			-- environment variables
    fopen: fopenFn,			-- capability to open files
    configuration: annotations		-- parameters and values
  )
  constant (filename, environ, fopen)
  exit {full};
  getChConfigurationQ: inport of getChConfiguration 
      {init(filename), init(environ), init(fopen)};
  getChConfigurationFn: outport of getChConfigurationQ;
  
  stringOption: callmessage (		-- get string value from an option
    option: polymorph,
    value: charstring
  )
  constant (option)
  exit {full};
  stringOptionQ: inport of stringOption {init(option)};
  stringOptionFn: outport of stringOptionQ;
  
  formatreal : callmessage(
    real : real,
    string : charstring
  )
  constant (real)
  exit {full};
  formatrealQ : inport of formatreal {init(real)};
  formatrealFn : outport of formatrealQ;
  
  initformatreal : callmessage(
    crtoa : ConvertRealToAsciiFn,
    rtoa : formatrealFn
  )
  constant (crtoa)
  exit {full};
  initformatrealQ : inport of initformatreal {init(crtoa)};
  initformatrealFn : outport of initformatrealQ;
  
  charstringSet: table of charstring {init} keys (*);

  programCm : callmessage(
      ch : chcontrols,
      liprog : prog,
      newprog: prog
    )
  exit {full}
  minimum {full(ch), full(liprog)};
  programQ : inport of programCm {full(ch),full(liprog)};
  programFn : outport of programQ;

  transform : callmessage(
      ch : chcontrols,
      liprog : prog,
      chpart : charstring
    )
  exit {full}
  exception already {full(ch), full(liprog)};
  transformQ : inport of transform {full(ch), full(liprog)};
  transformFn : outport of transformQ;

end definitions

