-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chphase1.d	1.1 9/25/91

chphase1: using(chdescriptors, chinternal, chtransform, interpform)

  definitions
    
    dictionary_init : callmessage(
	reference : lookupFn,
	lookup : lookupFn
      )
    exit {full};
    dictionaryI : inport of dictionary_init {};
    dictionaryFn : outport of dictionaryI;
    
    lookup : callmessage(
	ID : operand,
	family : data_family,
	operands : ch_operands,
	operand_index : integer
      )
    constant(ID)
    exit {full}
    minimum {init(ID), init(family), init(operands)};
    lookupQ : inport of lookup
       {init(ID), init(family), init(operands)};
    lookupFn : outport of lookupQ;
    
    assign : callmessage(
	destination : assignment,
	statement : ch_statement,
	operands : ch_operands,
	reveals : operandset
      )
    constant(destination, statement)
    exit {full}
    minimum {full};
    assignQ : inport of assign {full};
    assignFn : outport of assignQ;
    
    branches : callmessage(
	statements : ch_statements,
	jumps : statement_indices,
	branches : statement_indices,
	references : referencesFn
      )
    constant(references)
    exit {init(statements), init(branches), init(references)}
    minimum {init(statements), init(branches), init(references)};
    branchesQ : inport of branches {full};
    branchesFn : outport of branchesQ;
    
    operandsCm : callmessage(
	operands : ch_operands,
	equivalents : equivalents
      )
    exit {init(operands)};
    operandsQ : inport of operandsCm {full};
    operandsFn : outport of operandsQ;
    
    
    equivalents : table of equivalent {full} KEYS(*);
    equivalent : record(
	x1 : integer,		        -- operand index
	x2 : integer                    -- operand index
      );
    
    operandset : table of integer {init} KEYS(*);
    
  end definitions
