-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chphase2.p	1.3 3/2/92

-- This process collects cblocks.
--
-- Input is a statements table and an operands table.
--
-- Output is a cblocks table.  The input tables are usually modified.
--
-- A cblock starts with a 'ccode' or 'block' locus statement.  A 'block'
-- locus statement is the only statement in its cblock.  Otherwise a cblock
-- may include several successive 'ccode' locus statements.  The latter kind
-- of cblock is terminated by an 'interpret' or 'block' locus statement, by
-- the end of statements or by a 'ccode' (or 'omit') locus statement which
-- may be executed following a statement which is not among those already
-- collected for this block (i.e. is a branch target from some other cblock.)
--
-- The latter determination is implemented by the collection and examination
-- of 'branch' flow statements, using the references capability of the ch
-- argument and the serveCblocks internal process.  A 'ccode' locus
-- statement which terminates a cblock in this fashion (starting a new
-- cblock) is the first statement of a block handler, the back-latch of a
-- loop, or the target of a normal forward reference from some previous
-- cblock with an intervening Hermes block or blocking operation.
--
-- Following the collection of cblocks, the process chimprove_code and
-- chimprove_cblocks are called to make various kinds of improvements.
--

chphase2: using(chdescriptors, chinternal, chphase2, chtransform, interpform)
linking (chimprove_code,chimprove_cblocks)

  process(Q: phase2Q)
    
  declare
    
    cm: phase2;
    
    cblock: cblock;
    cblocks: cblocks;
    stx: integer;
    branches: statement_indices;
    interpreting: boolean;
    est: ch_statement;
    
    egress: egressFn;
    reference: referenceFn;
    serveCblocks: serveCblocksFn;
    e: empty;
    first: boolean;
    junk: boolean;
    
  begin
    
    receive cm from Q;
    if cm.ch.options.verbose then
	call cm.ch.put("phase2 ");
      end if;
    
    serveCblocks <- procedure of process (Q: serveCblocksQ)

	-- This process creates and serves two capabilities, used
	-- in discriminating internal branch targets (addresses)
	-- of a cblock from the head of the next cblock.
	   -- 
	   -- reference: tabulates branch targets; this capability
	   -- returns 'false' if the branch target is new, and
	   -- 'true' if it was previously tabulated (within the
	   -- current cblock).
	   -- 
	   -- egress: determines whether some reference to a given
	   -- statement is not a forward branch from within the
	   -- current cblock; this capability returns 'true' if 
	   -- there is such a reference, and 'false' otherwise
	   -- (The statement is eligible to be within the current
	   -- cblock.)
      
      declare
	cm: serveCblocks;
	egress: egress;
	egressQ: egressQ;
	reference: reference;
	referenceQ: referenceQ;
	target: target;
	targets: targets;
      begin
	receive cm from Q;
	new egressQ;
	connect cm.egress to egressQ;
	new referenceQ;
	connect cm.reference to referenceQ;
	return cm;
	new targets;
	while 'true' repeat
	    select
	      event egressQ
		receive egress from egressQ;
		block begin
		    inspect t in targets[egress.index] begin
			egress.reply <- (t.references <> egress.references);
		      end inspect;
		  on(NotFound)
		    egress.reply <- 'true';
		  end block;
		return egress;
	      event referenceQ
		receive reference from referenceQ;
		block begin
		    remove target from targets[reference.ix];
		    target.references <- target.references + 1;
		    reference.reply <- 'true';
		  on(NotFound)
		    new target;
		    target.index := reference.ix;
		    target.references <- 1;
		    reference.reply <- 'false';
		  end block;
		insert target into targets;
		return reference;
	      otherwise
	      end select;
	  end while;
	on (disconnected)
      end process;

    new cblocks;
    
    -- collect cblocks
    stx <- 0;
    
    interpreting <- 'true';
    first <- 'false';
    new cblock;
    new cblock.ingress;
    new cblock.statements;
    new cblock.otherlabels;
    call serveCblocks(egress, reference);
    new branches;
    
    while stx < size of cm.statements repeat
	inspect st in cm.statements[stx] begin
	    block begin
		if st.locus = 'interpret' then
		    if interpreting then
			exit proceed;
		      else
			exit interpret;
		      end if;
		  end if;
		if st.locus = 'omit' then
		    if st.references = 0 then
			exit proceed;
		      end if;
		    remove est from cm.statements[stx];
		    est.locus <- 'ccode';
		    est.opcode <- 'noop';
		    est.flow <- 'continue';
		    new est.operands;
		    unite est.qualifier.empty from e;
		    insert est into cm.statements at stx;
		  end if;
		-- st.locus = 'ccode' or 'block'
		if interpreting then
		    interpreting <- 'false';
		    first <- 'true';
		  else
		    if st.locus = 'block' then
			exit interpret; -- bind off the previous cblock
		      end if;
		  end if;
		if st.references <> 0 then
		    if not first then
		        call cm.references
			    (cm.statements, branches, reference, junk);
			if egress(stx, st.references) then
			    exit interpret;
			  end if;
			new branches;
		      end if;
		  end if;
		-- reference branch labels which are not frame labels.
		if st.flow = 'branch' then
		    insert copy of stx into branches;
		  end if;
		insert copy of stx into cblock.statements;
		if first then
		    if st.locus = 'block' then
			-- for now, blocking operations occupy private cblocks.
			stx <- stx + 1;
			exit interpret;
		      end if;
		    first <- 'false';
		    remove est from cm.statements[stx];
		    est.locus <- 'escape';
		    insert est into cm.statements at stx;
		  end if;
		stx <- stx + 1;
	      on exit(interpret)
		-- complete the current cblock
		cblock.first <- cblock.statements[0];
	        cblock.next := stx;
		insert size of cblocks into cblock.ingress;
		insert cblock into cblocks;
		
		interpreting <- 'true';
		first <- 'false';
		-- prepare an empty cblock
		new cblock;
		new cblock.ingress;
		new cblock.statements;
		new cblock.otherlabels;
		call serveCblocks(egress, reference);
		new branches;
	      
	      on exit(proceed)
		stx <- stx + 1;
	      end block;
	  end inspect;
      end while;
    if not interpreting then
	-- complete the last cblock
	cblock.first <- cblock.statements[0];
	cblock.next <- stx;
	insert size of cblocks into cblock.ingress;
	insert cblock into cblocks;
      end if;
    discard egress; discard reference;
    
    -- hermes code improvement
    
    call (improveFn#(create of process chimprove_code))
       (cm.ch, cblocks, cm.statements, cm.operands);
    
    call (improveFn#(create of process chimprove_cblocks))
       (cm.ch, cblocks, cm.statements, cm.operands);
    
    cm.cblocks <- cblocks;
    return cm;
    
  end process
