-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chtransform.p	1.2 2/8/92

-- This process sequences the transformation of one program.
--
-- Input is a prog, particularly its code table.
--
-- Output is a table of residual li-code, a text string (the transformed
-- C-code), and a new value of prog.size (see chphase3).
--
-- The three phases of the transformation are called in order.  A common
-- procedure, references, is provided as a service to each of the three
-- phases.
--
-- If chphase1 returns exception  already , chtransform returns exception
-- already , relaying the information that the code was output of a
-- previous transformation.
--

chtransform: using(chinternal, chtransform, interpform)
linking (chphase1,chphase2,chphase3)

  process(Q: transformQ)
    
  declare
    
    cm: transform;
    
    lipart: prog;
    program: program;
    references : referencesFn;
    
    statements: ch_statements;
    operands: ch_operands;
    cblocks: cblocks;
    
  begin
    receive cm from Q;
    
    references <- procedure of process(Q: referencesQ)
	--
	-- This process inspects each branch statement indexed in its
	-- input argument  stxs .  The statement must have a qualifier
	-- case which is one of 'integer', 'block', 'integer_pair',
	-- 'select' (These are all the possibilities for a statement
	-- which may branch.)
	--
	-- For each branch label, the supplied test process is called to
	-- determine whether the qualifier is changed, and to make the
	-- necessary changes to its label components.  A changed qualifier
	-- is replaced in its statements argument entry.
	--
	-- The process is used by each phase to implement some transformation
	-- of branch label references:
	--
	--   phase1: label reference counting and branch chaining improvement
	--           (see chbranches).
	--   phase2: recognizing references within a cblock (no change).
	--   phase3: recomputing branch addresses for statements with 'frame'
	--           flow ('block' and sometimes 'select') and for interpreted
	--           branch statements (see chupstate).
	--
      declare
	cm: references;
	change: boolean;
	qual: interpform!qualifier;
	labels: interpform!select_qual;
	blocks: interpform!block_qual;
	handler: interpform!block_handler;
	i: integer;
	chst: ch_statement;
      begin
	receive cm from Q;
	cm.result <- 'false';
	for stix in cm.stxs[] inspect
	    inspect st in cm.st[stix] begin
		qual := st.qualifier;
		select case of qual
		  where('block')
		    change <- 'false';
		    reveal qual.block;
		    new blocks;
		    for block_handler in qual.block[] inspect
			handler := block_handler;
			change <- change or cm.test(cm.st, handler.label);
			insert handler into blocks;
		      end for;
		    qual.block <- blocks;
		  where('integer')
		    reveal qual.integer;
		    call cm.test(cm.st, qual.integer, change);
		  where('integer_pair')
		    reveal qual.integer_pair;
		    if st.opcode = 'oeloop' then
			call cm.test(cm.st, qual.integer_pair.int_one, change);
		      else
			call cm.test(cm.st, qual.integer_pair.int_two, change);
		      end if;
		  otherwise
		    change <- 'false';
		    reveal qual.select;
		    new labels;
		    for label in qual.select[] inspect
			i := label;
			change <- change or cm.test(cm.st, i);
			insert i into labels;
		      end for;
		    qual.select <- labels;
		  end select;
		if change then
		    remove chst from cm.st[stix];
		    chst.qualifier <- qual;
		    insert chst into cm.st at stix;
		    cm.result <- 'true';
		  end if;
	      end inspect;
	  end for;
	return cm;
      end process;
    
    call (phase1Fn#(create of process chphase1))
	(cm.ch, cm.liprog.code, statements, operands, references);
    
    call (phase2Fn#(create of process chphase2))
	(cm.ch, cblocks, statements, operands, references);
    
    lipart := cm.liprog;
    new lipart.code;
    call (phase3Fn#(create of process chphase3))(
      cm.ch, cblocks, statements, operands, references, lipart, cm.chpart);
    cm.liprog <- lipart;

    return cm;
    
  on (phase1.already)
    return cm exception already;
  
  end process
