divert(-1)
# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# M4 macros to declare "hermes" objects and types in C code

# Output a C preprocessor definition
define(cppdef,`define(`_cppline',`#define $1 $2')_cppline')

# hobject(foo,type) declares a static object named foo_obj, and defines
# 'foo' to be its address and foo_val its value of valcell type 'type'
define(hobject,`
cppdef($1, (&$1_obj))
cppdef($1_val, ($1_obj.value.$2))
static object $1_obj')

# lobject(foo) declares an object named foo_lobj, and defines 'foo' to
# be its address.
define(lobject,`
cppdef($1, (&$1_lobj))
object $1_lobj')

# def_record(foo,a,b,c) defines cpp variables 'a', 'b', and 'c' to
# have the values 0, 1, and 2, respectively, and 'foo_Size' to have
# the value 3.  If there are more than 8 record components, you can
# nest component name lists as long as none of the nested lists has
# more than 9 components (names or sublists).  For example:
# def_record((a,b,c,d,e,f,g),(h,i,j,k,l,m,n)).  This bogosity is
# needed to get around m4's stupid 9-arg limit for macros.

define(def_record,`define(`_compno',0)dnl
def_comps($2,$3,$4,$5,$6,$7,$8,$9)dnl
cppdef($1_Size,_compno)
')

define(def_comps,`ifelse($1,,,
`ifelse(substr(translit($1,`(,)',`[.]'),0,1),[,`def_comps$1',
`cppdef($1,_compno)
define(`_compno',incr(_compno))')dnl
def_comps($2,$3,$4,$5,$6,$7,$8,$9)')')


# def_enumeration(a,b,c) defines cpp variables 'e_a', 'e_b', and 'e_c'
# to have the values 0, 1, and 2.  Use nested lists as in the case of
# def_record component names if you have more than 9 enumerators.

define(def_enumeration,`define(`_enumno',0)dnl
def_enums($1,$2,$3,$4,$5,$6,$7,$8,$9)')

define(def_enums,`ifelse($1,,,
`ifelse(substr(translit($1,(,),[.]),0,1),[,`def_enums$1',
`cppdef(e_$1,_enumno)
define(`_enumno',incr(_enumno))')def_enums($2,$3,$4,$5,$6,$7,$8,$9)')')

undefine(`index')
divert(0)dnl
