/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.14 2/7/92 */

/* Makefile for the Hermes code generator.  This make file resides in */
/* the codegen root directory, where nothing is actually built.  It */
/* contains targets that will cause the various phases of the code */
/* generator to be built in the proper sequence. */

/* Set the default target here at the top so there's no confusion... */
all:

/* Get standard stuff */
#include "includefile"

/* All the source files needed by the various builds... we make 'all' */
/* depend on each so they'll get copied out of SCCS if necessary */

DFILES	=	cginternal.d cginit.d bbassemble.d compoffsets.d \
			objaddr.d exprtree.d cgstmt.d 
PPFILES =	codegen.pp cginit.pp cgprocess.pp cgprocinit.pp \
			cgclause.pp cgstmt.pp cgdirectstmt.pp \
			cgtypedstmt.pp cgstmtstub.pp cgblock.pp \
			cgif.pp cgwhile.pp cgevery.pp cgexists.pp \
			cgextract.pp cgforinsp.pp cginsptbl.pp \
			cgremove.pp cgforall.pp cgposition.pp cgposofelt.pp \
			cgtheelement.pp cgselect.pp cgexprblock.pp \
			cgnamedlit.pp cgconvert.pp \
			cgforenum.pp cginsppoly.pp cgnew.pp \
			cgselector.pp breakselector.pp newtableinfo.pp \
			bbassemble.pp objaddr.pp objalias.pp optimize.pp \
			cgatoi.pp lkuptype.pp typedef.pp compoffsets.pp \
			varcaseid.pp clauseusesobj.pp mintsinfo.pp \
			makeexpr.pp exprassemble.pp exprusesroot.pp \
			makeopmap.pp cgator.pp
OTHERSRC =	codegen.h const.def vars.awk
SOURCES	=	$(DFILES) $(PPFILES) $(OTHERSRC)
all:	$(SOURCES)

ligen:	phase3
	( cd ligen ; $(MAKE) install )
phase3:	phase2
	( cd p3 ; $(MAKE) all )
phase2:	phase1 common
	( cd p2 ; $(MAKE) all )
phase1:	dofiles
	( cd p1 ; $(MAKE) all )
common:
	( cd com ; $(MAKE) all )
dofiles:
	( cd com ; $(MAKE) dofiles )
