-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: lkuptype.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)lkuptype.pp	1.5 1/11/92

-- This process looks up the typename of a given root object.  A given
-- collection of scopes is examined first, and then the given table of
-- inferred definitions is examined if that fails.

#include "typemark.h"
#include "codegen.h"

lkupType: using (cgInternal, inferredtype)

process (Q: lkupTypeQ)
  
declare
  args: lkupType;
begin
  receive args from Q;
  
  inspect scope in args.scopes[args.obj.scope] begin
    inspect decl in scope.declarations[args.obj.root] begin
      if B(typename_option#(case of decl.typename) =
	      typename_option#'named') then
	reveal decl.typename.typename;
	args.type := decl.typename.typename;
      else
	-- No declaration in absprog... we'll need one from inferred defs
	block begin
	  inspect infDef in args.infDefs[args.obj] begin
	    args.type := infDef.type;
	  end inspect;
	on (NotFound)
	  -- Missing a typemark... try to tell them the variable name
	  block begin
	    inspect var in args.rootMap where
		  (B(B(var.scope = args.obj.scope) and
		      B(var.root = args.obj.root))) begin
	      print S(S("Missing typemark for variable ") | var.name);
	    end inspect;
	  on (notFound)
	    print S("Missing typemark for unknown or temp variable");
	  end block;
	  discard args;
	  exit ugh;
	end block;
      end if;
    end inspect;
  end inspect;
  
  return args;

on exit(ugh)
end process
