-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: mintsinfo.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)mintsinfo.pp	1.2 3/13/90

-- This module computes a "discards list" and "hides list" to encode
-- the information necessary to lower an object (the "base object") of
-- the given type to the given typestate, assuming that its current
-- typestate is at least that high.  Each list takes the form of a
-- list (lexically sorted) of offset lists.  Each offset list
-- identifies an object contained in the base object, reachable by
-- following the given offsets in order.  If an object is in the
-- discards list, then it must be discarded if not already bottom.  If
-- an object is in the hides list, it must be a variant and it must be
-- hidden if currently revealed.

-- A top-level component x goes into the discards list iff init(x)
-- does not appear in the given typestate.  A component y.x goes into
-- the discards list if init(y) appears but init(y.x) does not (y need
-- not be a top-level object).  An object y (not necessarily
-- top-level) goes into the hides list if init(y) appears, y is a
-- variant, and caseof(y,y.z) does not appear for any component z of
-- y.

#include "typemark.h"
#include "codegen.h"

minTSInfo: using (cgInternal, minTSInfo)

process (Q: minTSInfoQ)
  
declare
  args: minTSInfo;
begin
  receive args from Q;
  
  -- Initialize discards and hides list to empty
  new args.discards;
  new arsg.hides;
  
  
