-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: objaddr.d
-- Author: Andy Lowry
-- SCCS Info: @(#)objaddr.d	1.4 2/14/92

-- Type definitions used internally by objAddr and friends

objAddr: using (interpform, cgInternal)

definitions


  -- A rootMap is a table relating absprog root names to LI
  -- addresses.  The type of the object is also available for
  -- convenience. 
  rootMap: table of rootMapEntry {full} keys (root);
  rootMapEntry: record (
    root: predefined!rootname,
    addr: interpform!operand,
    type: predefined!typename
  );
  
  -- An objAddrCache stores complete resolved addresses.  This not
  -- only improves lookup performance, it also allows identical
  -- addresses to be lazy copies of each other, both in memory and (as
  -- of 0.8alpha) in .po files.
  objAddrCache: table of objAddrCacheEntry {full} keys(objName);
  objAddrCacheEntry: record (
    objName: predefined!objectName,
    offsets: interpform!operand
  );

  -- objAlias is a process that sets itself up to intercept objAddr,
  -- rootAddr and setAddr calls in order to handle referenced to
  -- aliased objects.  The objAddr main process passes its inports for
  -- these services and gets back inports on which non-aliasing
  -- requests are forwarded for normal handling.  If the alias map
  -- ever becomes empty, the objAlias process sends the original
  -- inports back via the noAlias capability received in its init
  -- message.
  objAlias: callmessage (
      objAddrQ: objAddrQ,	-- the inports where requests will arrive
      rootAddrQ: rootAddrQ,
      setAddrQ: setAddrQ,
      noAlias: noAliasFn,	-- capability to restore non-aliasing
				-- services as primary handlers
      objType: objTypeFn,	-- other capabilities needed by aliaser
      compOffsets: compOffsetsFn
    )
    exit {init(objAddrQ), init(rootAddrQ), init(setAddrQ)};
  objAliasQ: inport of objAlias {full};
  objAliasFn: outport of objAliasQ;
    
  -- noAlias is the interface whereby an objAlias process returns the
  -- primary service inports to the non-aliasing objAddr process.
  -- This is done to reduce overhead in cases where no aliases are in
  -- effect (the vast majority of the time).
  noAlias: callmessage (
      objAddrQ: objAddrQ,	-- the original inports returned
      rootAddrQ: rootAddrQ,
      setAddrQ: setAddrQ
    )
    exit {};
  noAliasQ: inport of noAlias {full};
  noAliasFn: outport of noAliasQ;

  -- An objectMap is a table relating full absprog object names to LI
  -- addresses.  The type of the object is also available for
  -- convenience. 
  objectMap: table of objectMapEntry {full} keys (obj);
  objectMapEntry: record (
    obj: predefined!objectname,
    addr: interpform!operand,
    type: predefined!typename
  );
  
end definitions

