/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */

/* as usual, massive stuff stolen from fegram.yacc */

/*
 * yacc grammar for Hermes
 */

%{
#include "li.h"

#include "../fe/resolve.h"

#include "cherm.h"
#include "storage.h"

#include "construct.h"

#include "predefined.cd"
#include "errors.cd"


#undef TRUE
#undef FALSE
#undef CALLMESSAGE
#undef INITPORT

#define True -1
#define False 0

extern char yytext[];

/* we need a big stack because we're a big, important language! */
#define YYMAXDEPTH 500

extern objectp uninitobj;    /* the representation for an uninit object */

extern objectp bogus;       /* used to decide if the definition is bogus
                        and should not be put in list, or if 
                        inherit_att is bogus and should be ignored */

/* should either be a hash table or a hermes table */
extern name_definition name_def_table[TABLESIZE];

extern objectp lookup_typename();

objectp lookup_typename();
objectp c_lookup();
objectp c_integer();
objectp c_string();
objectp c_real();
objectp c_named_lit();
objectp c_init_variant();
objectp c_get_case_type();
objectp c_unite_variant();
objectp c_get_typename();
objectp p_type_or_attr_name();
objectp c_unique();
objectp c_new();
objectp c_typename_lit();
objectp c_attributename_lit();
objectp c_end_rectab();
recordtable_info c_init_rectab();
recordtable_info c_add_to_rectab();
void c_init_construct();
void c_init_absprog();
void c_add_def();
void c_print_table();
void c_end_construct();

%}


/*
 * token definitions are prepared automatically from the files "keywords" and
 * "othertokens".  we Include them here with m4.
 */

/* include same tokens as fegram, since we'll use the same tokenizer */

/* include(tokens.yacc) */

%token T_UNINITIALIZED
%token T_ERROR
%token T_SYMBOL
%token T_INTEGER
%token T_REAL
%token T_NAME
%token T_STRING
%token T_NAMESCASE
%token T_ASSIGN
%token T_NEQUAL
%token T_LEQUAL
%token T_GEQUAL
%token T_MOVE
%token PRINT
%token TYPENAME
%token ATTRIBUTENAME
%token ACCURACY
%token AGAINST
%token AND
%token AS
%token ASSERT
%token AT
%token BEGIN
%token BLOCK
%token BOOLEAN
%token CALL
%token CALLMESSAGE
%token CASE
%token CHECKDEFINITIONS
%token CONNECT
%token CONSTANT
%token CONSTRAINT
%token CONVERT
%token COPY
%token CREATE
%token CURRENTPROGRAM
%token DECLARE
%token DEFINITIONS
%token DISCARD
%token DISSOLVE
%token DROP
%token ELSE
%token EMPTY
%token END
%token ENUMERATION
%token EVALUATE
%token EVENT
%token EVERY
%token EXCEPT
%token EXCEPTION
%token EXISTS
%token EXIT
%token EXTRACT
%token FALSE
%token FOR
%token FORALL
%token FROM
%token HIDE
%token IF
%token IN
%token INPORT
%token INSERT
%token INSPECT
%token INTEGER
%token INTO
%token IS
%token KEYS
%token LINKING
%token MERGE
%token MINIMUM
%token MOD
%token NEW
%token NOMINAL
%token NOT
%token OF
%token ON
%token OR
%token ORDERED
%token OTHERWISE
%token OUTPORT
%token POLYMORPH
%token POSITION
%token PRAGMA
%token PROCEDURE
%token PROCESS
%token REAL
%token RECEIVE
%token RECORD
%token REM
%token REMOVE
%token REPEAT
%token RETURN
%token REVEAL
%token SELECT
%token SEND
%token SIZE
%token TABLE
%token THEN
%token TO
%token TRUE
%token TYPE
%token TYPESTATE
%token UNIQUE
%token UNITE
%token UNWRAP
%token USING
%token VARIANT
%token WHERE
%token WHILE
%token WRAP


/* the types of the objects each rule returns */
%union {
	char *string;
	object *obj;
    object *inherit_att;  /* pointer to a type_definition */
    recordtable_info rectab_info;  /* size and object for record/table */
       }

%type <obj>    type_name
%type <obj>    attribute_name
%type <string> item_name
%type <obj>    constructor_expression
%type <rectab_info> constructor_element_list
%type <string> definition_name
%type <string> module_name
%type <string> identifier
%type <string> named_literal
%type <string> string_literal
%type <string> integer_literal
%type <string> real_literal

/*
 * start symbol -- a constructor_file
 */

%start constructor_file

%%

constructor_file : 
    { c_init_construct(); }
    imports
    construct_assignments_list
    END
    { c_end_construct(); } ;

construct_assignments_list : construct_assignment;

construct_assignments_list : construct_assignments_list
    construct_assignment;

construct_assignment : item_name ':' type_name assign
    { $<inherit_att>$ = $3; } 
    constructor_expression 
    ';' 
    { c_add_def($1, $3, $6); } ;


/* inside a constructor_expression rule $0 always is an inherited
   attribute containing the typename of the type we're in.
*/

constructor_expression : item_name
    { $$ = c_lookup($<inherit_att>0, $1); } ;

constructor_expression : integer_literal
    { $$ = c_integer($<inherit_att>0, $1); } ;

constructor_expression : string_literal
    { $$ = c_string($<inherit_att>0, $1); } ;

constructor_expression : real_literal
    { $$ = c_real($<inherit_att>0, $1); } ;

constructor_expression : named_literal
    { $$ = c_named_lit($<inherit_att>0, $1); } ;

constructor_expression : named_literal 
    { $<obj>$ = c_init_variant($<inherit_att>0, $1); }
    ':' 
    { $<inherit_att>$ = c_get_case_type($<inherit_att>0, $<obj>2); }
    constructor_expression
    { $$ = c_unite_variant($<inherit_att>0, $<obj>2, $5); } ;

constructor_expression : '{' 
    constructor_element_list 
    '}' 
    { $$ = c_end_rectab($<inherit_att>0, $2); } ;

constructor_expression : UNIQUE
    { $$ = c_unique($<inherit_att>0); } ;

constructor_expression : NEW
    { $$ = c_new($<inherit_att>0); } ;

constructor_expression : '\\' TYPENAME type_name '\\'
    { $$ = c_typename_lit($<inherit_att>0, $3); } ;

constructor_expression : '\\' ATTRIBUTENAME attribute_name '\\'
    { $$ = c_attributename_lit($<inherit_att>0, $3); } ;

constructor_expression : empty
    { $$ = uninitobj; } ;

constructor_element_list : 
    { $<rectab_info>$ = c_init_rectab($<inherit_att>-1); }
    empty  /* this is sleazy, but I need to return two values */
    { $<inherit_att>$ = 
            c_get_typename($<inherit_att>-1, $<rectab_info>1.size); }
    constructor_expression
    { $$ = c_add_to_rectab($<inherit_att>-1, $<rectab_info>1, $4); } ;

constructor_element_list : 
    constructor_element_list 
    ','
    { $<inherit_att>$ = 
            c_get_typename($<inherit_att>-1, $<rectab_info>1.size); }
    constructor_expression
    { $$ = c_add_to_rectab($<inherit_att>-1, $<rectab_info>1, $4); } ;

item_name : identifier;

definition_name : identifier;

type_name : definition_name
	{ $$ = p_type_or_attr_name(p_qual_name(nil, $1), True); } ;

type_name : module_name '!' definition_name
	{ $$ = p_type_or_attr_name(p_qual_name($1, $3), True); } ;

attribute_name : definition_name
	{ $$ = p_type_or_attr_name(p_qual_name(nil, $1), False); } ;

attribute_name : module_name '!' definition_name
	{ $$ = p_type_or_attr_name(p_qual_name($1, $3), False); } ;

assign : T_ASSIGN ;

real_literal : T_REAL 
	{ $$ = copystring(yytext); } ;

integer_literal : T_INTEGER 
	{ $$ = copystring(yytext); } ;

string_literal : T_STRING 
	{ $$ = copystring(yytext); } ;

named_literal : T_NAME 
	{ $$ = copystring(yytext); } ;

empty : ;

imports : USING '(' module_name_list ')' ;

module_name_list : empty 
    { p_mod_import(copystring("predefined")); }
module_name_list : module_name_NElist ;
module_name_NElist : module_name 
	{ p_mod_import(copystring("predefined"));
      p_mod_import($1); } ;
module_name_NElist : module_name_NElist ',' module_name 
	{ p_mod_import($3); } ;

module_name : identifier;

/* identifier stuff -- taken from fegram.yacc */

/* include(ident.yacc) */


identifier : T_SYMBOL { $$ = downcase(copystring(yytext)); } ;
identifier : PRINT { $$ = downcase(copystring("PRINT")); } ;
identifier : TYPENAME { $$ = downcase(copystring("TYPENAME")); } ;
identifier : ATTRIBUTENAME { $$ = downcase(copystring("ATTRIBUTENAME")); } ;
identifier : ACCURACY { $$ = downcase(copystring("ACCURACY")); } ;
identifier : AGAINST { $$ = downcase(copystring("AGAINST")); } ;
identifier : AS { $$ = downcase(copystring("AS")); } ;
identifier : ASSERT { $$ = downcase(copystring("ASSERT")); } ;
identifier : AT { $$ = downcase(copystring("AT")); } ;
identifier : BLOCK { $$ = downcase(copystring("BLOCK")); } ;
identifier : BOOLEAN { $$ = downcase(copystring("BOOLEAN")); } ;
identifier : CALL { $$ = downcase(copystring("CALL")); } ;
identifier : CALLMESSAGE { $$ = downcase(copystring("CALLMESSAGE")); } ;
identifier : CASE { $$ = downcase(copystring("CASE")); } ;
identifier : CHECKDEFINITIONS { $$ = downcase(copystring("CHECKDEFINITIONS")); } ;
identifier : CONNECT { $$ = downcase(copystring("CONNECT")); } ;
identifier : CONSTANT { $$ = downcase(copystring("CONSTANT")); } ;
identifier : CONSTRAINT { $$ = downcase(copystring("CONSTRAINT")); } ;
identifier : CONVERT { $$ = downcase(copystring("CONVERT")); } ;
identifier : COPY { $$ = downcase(copystring("COPY")); } ;
identifier : CREATE { $$ = downcase(copystring("CREATE")); } ;
identifier : DECLARE { $$ = downcase(copystring("DECLARE")); } ;
identifier : DEFINITIONS { $$ = downcase(copystring("DEFINITIONS")); } ;
identifier : DISCARD { $$ = downcase(copystring("DISCARD")); } ;
identifier : DISSOLVE { $$ = downcase(copystring("DISSOLVE")); } ;
identifier : DROP { $$ = downcase(copystring("DROP")); } ;
identifier : EMPTY { $$ = downcase(copystring("EMPTY")); } ;
identifier : ENUMERATION { $$ = downcase(copystring("ENUMERATION")); } ;
identifier : EVERY { $$ = downcase(copystring("EVERY")); } ;
identifier : EXCEPT { $$ = downcase(copystring("EXCEPT")); } ;
identifier : EXCEPTION { $$ = downcase(copystring("EXCEPTION")); } ;
identifier : EXISTS { $$ = downcase(copystring("EXISTS")); } ;
identifier : EXIT { $$ = downcase(copystring("EXIT")); } ;
identifier : EXTRACT { $$ = downcase(copystring("EXTRACT")); } ;
identifier : FALSE { $$ = downcase(copystring("FALSE")); } ;
identifier : FOR { $$ = downcase(copystring("FOR")); } ;
identifier : FORALL { $$ = downcase(copystring("FORALL")); } ;
identifier : FROM { $$ = downcase(copystring("FROM")); } ;
identifier : HIDE { $$ = downcase(copystring("HIDE")); } ;
identifier : IF { $$ = downcase(copystring("IF")); } ;
identifier : IN { $$ = downcase(copystring("IN")); } ;
identifier : INPORT { $$ = downcase(copystring("INPORT")); } ;
identifier : INSERT { $$ = downcase(copystring("INSERT")); } ;
identifier : INSPECT { $$ = downcase(copystring("INSPECT")); } ;
identifier : INTEGER { $$ = downcase(copystring("INTEGER")); } ;
identifier : INTO { $$ = downcase(copystring("INTO")); } ;
identifier : IS { $$ = downcase(copystring("IS")); } ;
identifier : KEYS { $$ = downcase(copystring("KEYS")); } ;
identifier : LINKING { $$ = downcase(copystring("LINKING")); } ;
identifier : MERGE { $$ = downcase(copystring("MERGE")); } ;
identifier : MINIMUM { $$ = downcase(copystring("MINIMUM")); } ;
identifier : MOD { $$ = downcase(copystring("MOD")); } ;
identifier : NOMINAL { $$ = downcase(copystring("NOMINAL")); } ;
identifier : OF { $$ = downcase(copystring("OF")); } ;
identifier : OR { $$ = downcase(copystring("OR")); } ;
identifier : ORDERED { $$ = downcase(copystring("ORDERED")); } ;
identifier : OUTPORT { $$ = downcase(copystring("OUTPORT")); } ;
identifier : POLYMORPH { $$ = downcase(copystring("POLYMORPH")); } ;
identifier : POSITION { $$ = downcase(copystring("POSITION")); } ;
identifier : PROCEDURE { $$ = downcase(copystring("PROCEDURE")); } ;
identifier : REAL { $$ = downcase(copystring("REAL")); } ;
identifier : RECEIVE { $$ = downcase(copystring("RECEIVE")); } ;
identifier : RECORD { $$ = downcase(copystring("RECORD")); } ;
identifier : REM { $$ = downcase(copystring("REM")); } ;
identifier : REMOVE { $$ = downcase(copystring("REMOVE")); } ;
identifier : REPEAT { $$ = downcase(copystring("REPEAT")); } ;
identifier : RETURN { $$ = downcase(copystring("RETURN")); } ;
identifier : REVEAL { $$ = downcase(copystring("REVEAL")); } ;
identifier : SELECT { $$ = downcase(copystring("SELECT")); } ;
identifier : SEND { $$ = downcase(copystring("SEND")); } ;
identifier : SIZE { $$ = downcase(copystring("SIZE")); } ;
identifier : TABLE { $$ = downcase(copystring("TABLE")); } ;
identifier : TO { $$ = downcase(copystring("TO")); } ;
identifier : TRUE { $$ = downcase(copystring("TRUE")); } ;
identifier : TYPE { $$ = downcase(copystring("TYPE")); } ;
identifier : TYPESTATE { $$ = downcase(copystring("TYPESTATE")); } ;
identifier : UNITE { $$ = downcase(copystring("UNITE")); } ;
identifier : UNWRAP { $$ = downcase(copystring("UNWRAP")); } ;
identifier : USING { $$ = downcase(copystring("USING")); } ;
identifier : VARIANT { $$ = downcase(copystring("VARIANT")); } ;
identifier : WHILE { $$ = downcase(copystring("WHILE")); } ;
identifier : WRAP { $$ = downcase(copystring("WRAP")); } ;


%%

/* programs in construct.ch */
