-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disasm: using 
   (predefined,common,interpform,main,disassembler,loadprog,parse,
    listuff,unix,disinternal,posmap,load,objectio,stdenv)
  process (Q: mainQ)
  declare
    args: main;
    stuffedprog: predefined!program;
    prog: interpform!prog;
    pms: disassembler!printmaps;
    disasm: predefined!charstring;
    poly: common!polymorph;
    LIUnstuff: LIUnstuffFn;
    loadProg: loadProgFunc;
    program: predefined!program;
    links: linkedPrograms;
    defmaps: predefined!definitions_printmappings;
    procmaps: predefined!executable_printmappings;
    posmaps: position_mappings;
    disassembler: disassemblerFn;
    diskname: charstring;
    message: charstring;
    liname: charstring;
    stdenv: stdenv;
    stdio: stdio;
  begin
    receive args from Q;

    -- mock up an old-style stdenv for the disassebler
    new stdenv;
    unwrap stdenv.load from args.rm.get("load", "") {init};
    unwrap stdenv.pathload from args.rm.get("pathLoad", "") {init};
    unwrap stdenv.readobj from args.rm.get("readObj", "") {init};
    unwrap stdenv.pathReadObj from args.rm.get("pathReadObj", "") {init};
    unwrap stdenv.writeObj from args.rm.get("writeObj", "") {init};
    unwrap stdenv.libWriteObj from args.rm.get("libWriteObj", "") {init};
    unwrap stdenv.store from args.rm.get("store", "") {init};
    unwrap stdenv.libStore from args.rm.get("libStore", "") {init};
    unwrap stdenv.getCwd from args.rm.get("getCwd", "") {init};
    unwrap stdenv.setCwd from args.rm.get("setCwd", "") {init};
    stdenv.terminal := args.terminal;

    unwrap stdio from args.rm.get("stdio", "") {init, init(fopen)};

    -- Load the support programs
    loadProg <- procedure of stdenv.pathload("loadprog");
    LIUnstuff <- procedure of stdenv.pathload("liunstuff");
    disassembler <- procedure of stdenv.pathload("disassembler");
    -- Disassemble each command line argument
    for basename in args.argv where (position of basename > 1)
      inspect
	block
	  declare
	    badmodule: predefined!charString;
	  begin
	    call args.terminal.putString(basename | ":");
	    -- load the program
	    call args.terminal.putString(" load[" | basename | ".ao]");
	    block
	      begin
		call loadProg(basename,stdenv.pathReadObj,
		    program,links,defmaps,procmaps,posmaps,badmodule);
	      on (loadProgIntf.programNotFound)
		call args.terminal.putLine(" ERRORS");
		call args.terminal.putString(basename);
		call args.terminal.putLine(".ao was not found.");
		exit badAbsprog;
	      on (loadProgIntf.definitionInconsistent)
		call args.terminal.putLine(" ERRORS");
		call args.terminal.putString(badModule);
		call args.terminal.putLine(
		    " was inconsistent with other definitions.");
		exit badAbsprog;
	      on (loadProgIntf.definitionNotFound)
		call args.terminal.putLine(" ERRORS");
		call args.terminal.putString(badModule);
		call args.terminal.putLine(".do was not found.");
		exit badAbsprog;
	      end block;
	    -- load the li
	      call args.terminal.putString(" load[" | basename | ".po]");
	    liname := basename;
	    merge ".po" into liname;
	    poly <- stdenv.pathReadObj(liname);
	    unwrap stuffedprog from poly { init, init(definitions_modules),
	      init(main_program), init(programs)};
	    prog <- LIUnstuff(stuffedprog);
	    -- setup for the call
	    -- print "Setup for the call";
	    new pms;
	    pms.execs := procmaps;
	    pms.defs := defmaps;
	    unite pms.progid.pid from copy of program.main_program;
	    -- disassemble
	    call args.terminal.putString(" disassemble");
	    disasm <- disassembler(prog,stdenv,pms);

	    block
	      declare
		file: stream;
	      begin
		-- store the result
		call args.terminal.putString(" write[" | basename | ".li]");
		diskname <- ".li";
		merge copy of basename into diskname at 0;
		file <- stdio.fopen(diskname,'write');
		call file.fputs(disasm);
		call file.fclose();
	      call args.terminal.putLine("");
	      on (others)
		call args.terminal.putLine(" ERRORS");
		call args.terminal.putLine("Couldn't write output file.");
	      end block;
	  on exit (badAbsprog)
	    -- just try the next one...
	  on (others)
	    call args.terminal.putLine(" ERRORS");
	    call args.terminal.putLine(
		"Unexpected error during disassembly.");
	  end block;
      end for;
    -- Return 
    return args;
  end process
