-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: sorterrors.d
-- Author: Andy Lowry
-- SCCS Info: @(#)sorterrors.d	1.1 1/24/92

sorterrors: using (errors, posmap, positions)
definitions
  
  -- take a bunch of error records and sort by filename and position.
  -- positions in all error records should be in case 'source'; if any
  -- are in case 'absprog', they will be placed at the end of the
  -- sort, in no particular order.
  sortErrors: callmessage (
    errors: errors		-- errors to be sorted
  )
  exit {full};
  sortErrorsQ: inport of sortErrors {full};
  sortErrorsFn: outport of sortErrorsQ;
  
  
  -- turn a procErrors list into an errors table, with all position
  -- components placed in the 'source' case
  sortProcErrors: callmessage (
    errors: procErrors,		-- errors to be sorted
    posmaps: position_mappings	-- relates absprog posn's to source posn's
  )
  constant (posmaps)
  exit {full};
  sortProcErrorsQ: inport of sortProcErrors {full};
  sortProcErrorsFn: outport of sortProcErrorsQ;

  compareCPositions: callmessage (
    pos1: cposition,
    pos2: cposition,
    switch: boolean		-- true if pos2 < pos1
  )
  constant (pos1, pos2)
  exit {full};
  compareCPositionsQ: inport of compareCPositions {full(pos1),full(pos2)};
  compareCPositionsFn: outport of compareCPositionsQ;
  
end definitions

