-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: fixdefs.p
-- Author: Rob Strom
-- SCCS Info: @(#)fixdefs.p	1.1 7/28/89

-- Program to post-process a definitions module
-- getting rid of all the uses of FULL and expanding them to INIT
-- filling in minimum formal typestate for callmessages

fixdefsint: using (filedef,
  inferredtype, interpform,  
  objectIO, fixfull, fixmin, fixdefs)
  process ( initport: FixdefsInport )

declare
  FP: FixdefsCall; -- formal parameters
  fixfull: FixFullOutport; -- program to replace full by init
  shorten: FixFullOutport; -- program to eliminate attributes implied by init(cm)
  insert_minimum: FixMinOutport; -- program to insert minimum TS
begin 
  receive FP from initport;

-- Load the code for subprograms
  fixfull <- PROCEDURE OF FP.Std.PathLoad("fixfull");
  shorten <- PROCEDURE OF FP.Std.PathLoad("shorten");
  insert_minimum <- PROCEDURE OF FP.Std.PathLoad("fixmin");

  
-- Pass I: fixing full/init(*) and defaulting minimum typestate
-- 7. fix the full in all formal TS's in the module to be fixed
-- 8. for callmessages,
--    if the user didn't supply a minimum
--    (which we infer by empty formal-typestate), then
--    generate one in the following way:
--    init(*)
--    For each constant parameter P, include init(P) if it's in exit TS.
--      If P is a record/cm, recursively include components of P if in exit TS.
-- Pass II: suppressing attributes already implied by init(cm)
-- 9. for each formal TS in the module to be fixed, except CM minimums
--   identify attributes of the form init(x), where x is a callmessage,
--    (a) expand (recursively) all implied attributes
--    (b) delete all implied attributes
-- End pass II
  

-- 7. Do the two passes: (7-8 on pass 1, 9 on pass 2)
--    Steps 7 and 9 differ only in that Fixfull is called on pass1,
--    and Shorten on pass2.


  block 
    declare
      newdefinition: type_definition; -- definition being recreated
      newdefinitions: type_definitions; -- module being recreated
      newcasemapping: partitionset; 
      newpartition: partition_info;
      cmtype: typename;
      newexceptionspecifications: exception_specifications;
      newexceptionspecification: exception;
      fixformals: fixformals; -- table mapping passes into function
      
    begin
      new fixformals;
      insert copy of fixfull into fixformals;
      insert copy of shorten into fixformals;
      FOR pass in fixformals where('true')
        INSPECT
	  new newdefinitions;
	  while (size of FP.ToBeFixed.Definitions_Module.type_definitions > 0)
	    repeat
	      remove newdefinition from n in FP.ToBeFixed.Definitions_Module.type_definitions where('true');
	      select (case of newdefinition.specification)
		where('varianttype')
		  reveal newdefinition.specification.variant_info;
		  new newcasemapping;
		  while (size of newdefinition.specification.variant_info.case_mapping > 0)
		    repeat
		      remove newpartition from p in newdefinition.specification.variant_info.case_mapping where('true');
		      inspect componentdeclaration in newdefinition.component_declarations where(componentdeclaration.id = newpartition.component_id)
			begin
			  call pass(FP.Definitions, newpartition.case_typestate, componentdeclaration.type);
			end inspect;
		      insert newpartition into newcasemapping;
		    end while;
		  newdefinition.specification.variant_info.case_mapping <- newcasemapping;
		where('inporttype')
		  reveal newdefinition.specification.inport_info;
		  call pass(FP.Definitions, newdefinition.specification.inport_info.message_typestate, newdefinition.specification.inport_info.message_type);
		where('tabletype')
		  reveal newdefinition.specification.table_info;
		  call pass(FP.Definitions, newdefinition.specification.table_info.element_typestate, newdefinition.specification.table_info.element_type);
		where('callmessagetype')
		  reveal newdefinition.specification.callmessage_info;
		  new cmtype;
		  cmtype.moduleid := FP.ToBeFixed.Definitions_Module.id;
		  cmtype.typeid := newdefinition.id;
		  call pass(FP.Definitions, newdefinition.specification.callmessage_info.normal, cmtype);
		  new newexceptionspecifications;
		  while (size of newdefinition.specification.callmessage_info.exception_specifications > 0)
		    repeat
		      remove newexceptionspecification from e in newdefinition.specification.callmessage_info.exception_specifications where('true');
		      IF pass = shorten AND newexceptionspecification.exceptionid = newdefinition.specification.callmessage_info.minimum
		        THEN
		        ELSE
			  call pass(FP.Definitions, newexceptionspecification.post_typestate, cmtype);
			END IF;
		      insert newexceptionspecification into newexceptionspecifications;
		    end while;
		  newdefinition.specification.callmessage_info.exception_specifications <- newexceptionspecifications;
		  -- 8. 
                  IF pass = fixfull
                    THEN
		      block
			declare
			  DiscardedException: Exception;
			begin
			  remove DiscardedException from exc in newdefinition.specification.callmessage_info.exception_specifications where(exc.exceptionid = newdefinition.specification.callmessage_info.minimum);
			  IF SIZE OF DiscardedException.Post_Typestate = 0
			    THEN
			      new DiscardedException.Post_Typestate;
			      insert evaluate InitStar: Formal_Attribute FROM
				NEW InitStar;
				UNITE InitStar.Attribute_Name.Init FROM evaluate Nothing: Empty FROM END;
				NEW InitStar.Parameters;
				INSERT EVALUATE Star: Component_List FROM
				  NEW Star;
				  END INTO InitStar.Parameters;
				END INTO DiscardedException.Post_Typestate;
			      for constant in newdefinition.specification.callmessage_info.constants where('true')
				inspect
				  call insert_minimum(constant, evaluate Null: Component_List from new Null; END, newdefinition.component_declarations, FP.Definitions, newdefinition.specification.callmessage_info.normal, DiscardedException.Post_Typestate);
				end for;
	                    END IF; 
			  insert DiscardedException into newdefinition.specification.callmessage_info.exception_specifications;
			end block;
                    END IF;
		otherwise
		end select;
	      insert newdefinition into newdefinitions;
	    end while;

	  FP.ToBeFixed.Definitions_Module.type_definitions <- newdefinitions;
	  -- On all but the last pass, fix the Definitions to include the changes from this pass
	  IF POSITION OF pass < SIZE OF fixformals - 1
	    THEN
	      BLOCK
		DECLARE
		  DiscardedModule: Definitions_Module; -- copy in Definitions of Module being fixed
		BEGIN
		  remove DiscardedModule from FP.definitions[FP.ToBeFixed.Definitions_Module.Id];
		  discard DiscardedModule;
		  insert copy of FP.ToBeFixed.Definitions_Module into FP.Definitions;
		END BLOCK;   
            END IF;
        END FOR;

    end block;
  

  return FP;

end process
