-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)getfile.p	1.8 1/11/92

getfile: using (getfile, unix) process (initQ: getFileInitQ)

declare
  init: getFileInit;
  q: getFileQ;
  fopen: fopenFn;

begin
  receive init from initQ;
  fopen := init.fopen;
  new q;
  connect init.getFile to q;
  return init;

-- service loop

  while boolean#'true' repeat block 
    declare
      getFile: getFile;
      nread: integer;
      file: stream;
      stat: fileStatus;
    begin
      block begin
	receive getFile from q;
      on (disconnected)
	exit done;
      end block;
      block begin
	file <- stream#(fopen(getfile.name, opentype#'read'));
      on (fopen.couldNotOpen)
	exit cantRead;
      end block;
      stat <- fileStatus#(file.fstat());
      getFile.file <- charstring#(file.fread(stat.size));
      call file.fclose();
      return getFile;
    on exit (cantRead)
      return getFile exception cantRead;
    on exit(done)
      exit done;
    on (others)
      discard getFile;
    end block;
  end while;

on exit(done)
end process
