/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)o_ubiq.c	1.10 2/17/92";
#endif

#include "ops.h"
#include "recursiv.h"
#include "ops_parm.h"
#include "storage.h"

NILOP(o_move)
{
    void re_finalize();


    re_finalize(DstObj, F_DISCARD, args->sched);
				/* finalize the value of the destination; */
    *(DstObj) = *(SrcObj);	/* copy entire object cell from src to dst */
    set_bottom(SrcObj);		/* set src typestate to bottom */
}


NILOP(o_copy)
{
    predef_exception re_copy();
    void re_finalize();
    predef_exception retcode;
    object copy;
    extern flag cherm_flag;

    if ((retcode = re_copy(SrcObj, &copy)) isnt Normal)
      raise_builtin(retcode);
    else {
      if (not cherm_flag)
	re_finalize(DstObj, F_DISCARD, args->sched);
				/* finalize the value of the destination; */
      *(DstObj) = copy;
    }
}


predef_exception
re_copy(src, dst)
object *src, *dst;
{
    extern datarep *datarepmap[];

    predef_exception retcode;
    if ((retcode = Copy(dst,src)) is Normal)
				/* copy the non-quopy datarep. */
      dst->tsdr = datarepmap[src->tsdr->number];
    return(retcode);
}


NILOP(o_equal)
{
    status re_equal();

    if (re_equal(Src1Obj, Src2Obj) is SUCCESS)
      Dst.boolean = nil_true;
    else
      Dst.boolean = nil_false;
    set_init(DstObj, dr_boolean);
}


status
re_equal(s1, s2)
object *s1, *s2;
{
  if (s1->tsdr->number is s2->tsdr->number)
    return(Equal(s1, s2));
  else
    return(FAILURE);
}



NILOP(o_notequal)
{
    status re_equal();

    if (re_equal(Src1Obj, Src2Obj) is FAILURE)
      Dst.boolean = nil_true;
    else
      Dst.boolean = nil_false;

    set_init(DstObj, dr_boolean);
}



void
re_finalize(obj, f_op, sched)
object *obj;
finalize_op f_op;
schedblock *sched;
{
    Finalize(obj, f_op, sched); /* finalize value */
    set_bottom(obj);		/* set tsdr to bottom */
}


NILOP(o_discard)
{
    void re_finalize();
  
    re_finalize(DstObj, F_DISCARD, args->sched);
				/* invoke type-dependent finalization; */
}


NILOP(o_softbottom)
{
    void re_finalize();

    register counter i;
    register object *op;

    for (i = 0; (op = args->operandstack[i]) isnt nil; i++)
      re_finalize(op, F_DISCARD, args->sched);
}
    
