/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: o_var.c */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)o_var.c	1.10 2/15/92";
#endif

#include "ops.h"
#include "storage.h"

#define Dst (DstObj->value)
#define Src (SrcObj->value)

extern datarep dr_bottom, dr_variant, dr_enumeration;

NILOP(o_unite)
{
    predef_exception che_unite();
    predef_exception retcode;

    if ((retcode = che_unite(DstObj, SrcObj, args->sched, 
			     args->qualifiers.integer)) != Normal)
	raise_builtin(Depletion);
}

predef_exception
che_unite(dstobj, srcobj, sched, variant_case)
objectp dstobj;
objectp srcobj;
schedblock *sched;
counter variant_case;
{
    void re_finalize();
    dfd_variant *newvar;

    if (dstobj->tsdr->number is dr_bottom.number)
      if ((newvar = getdotmain(VARIANT_SIZE)) is nil) {
	  return(Depletion);
      }
      else 
	dstobj->value.variant = newvar;
    else
      re_finalize(& dstobj->value.variant->data[VARIANT_COMPONENT], F_DISCARD,
		  sched);
				/* if not already bottom, finalize the */
				/*  component. */
	
    dstobj->value.variant->info.variant_case = variant_case;
				/* set the case. */

    dstobj->value.variant->data[VARIANT_COMPONENT] = *srcobj;
				/* copy entire object cell from src to dst */

    set_init(dstobj, dr_variant);
    set_bottom(srcobj);		/* [1] make source object uninit */
    return(Normal);
}


NILOP(o_dissolve)
{
    void re_finalize();
    extern flag cherm_flag;

    OPCHK(SrcObj,variant);
    if (not cherm_flag)
      re_finalize(DstObj, F_DISCARD, args->sched);
				/* finalize the value of the destination; */
    *(DstObj) = Src.variant->data[VARIANT_COMPONENT];
    { freedotmain(Src.variant, VARIANT_SIZE); }
    set_bottom(SrcObj);
}


NILOP(o_reveal)
{
    OPCHK(DstObj,variant);
    if (args->qualifiers.integer isnt Dst.variant->info.variant_case)
      raise_builtin(CaseError);
}


/*ARGSUSED*/
NILOP(o_hide)
{
/* i'm a no-op and i'm okay.  actually, i'm a typestate assertion. */
    OPCHK(DstObj,variant);
}


NILOP(o_case)
{
    OPCHK(SrcObj,variant);
    Dst.enumeration = Src.variant->info.variant_case;
    set_init(DstObj, dr_enumeration);
}


NILOP(o_ord_case)
{
    OPCHK(SrcObj,variant);
    Dst.ord_enum = Src.variant->info.variant_case;
    set_init(DstObj, dr_ord_enumeration);
}

void
fin_variant(value, f_op, sched)
valcell value;
finalize_op f_op;
schedblock *sched;
{
    void re_finalize();

    re_finalize(& value.variant->data[VARIANT_COMPONENT], f_op, sched);
    { freedotmain(value.variant, VARIANT_SIZE); }
}


predef_exception
cp_variant(dst, src)
valcell *dst, src;
{
    predef_exception re_copy();
    predef_exception retcode;
    valcell newvar;


    if ((newvar.variant = (dfd_variant *) getdotmain(VARIANT_SIZE)) is nil)
      return(Depletion);
    newvar.variant->info.variant_case = src.variant->info.variant_case;
    retcode = re_copy(& src.variant->data[VARIANT_COMPONENT],
		      & newvar.variant->data[VARIANT_COMPONENT]);
    if (retcode is Normal)
      dst->variant = newvar.variant;
    else
      { freedotmain(newvar.variant, VARIANT_SIZE); }
    return(retcode);
}


status
eq_variant(v1, v2)
valcell v1, v2;
{
    status re_equal();

    if (v1.variant->info.variant_case is v2.variant->info.variant_case)
      return(re_equal(& v1.variant->data[VARIANT_COMPONENT],
		    & v2.variant->data[VARIANT_COMPONENT]));
    else
      return(FAILURE);
}
