-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rshellac.p
-- Author: Andy Lowry
-- SCCS Info: @(#)rshellac.p	1.3 3/11/91

-- This process serves as an access function for the remote shell
-- facility.  Each time a request comes in, a user-level resource
-- manager is created using the user named in the request and the
-- system-level resource manager provided at initialization of this
-- process.  That resource manager is then passed off to a process
-- that will wait for the incoming rShell call and execute that call.

rShellAc: using (rShellInt, sysRManager, rManager, userRM, 
  personalRM, chainedRM)
linking (userRM, rShellExec, personalRM, chainedRM)

process (initQ: rShellInitQ)
  
declare
  initArgs: rShellInit;
  sysRM: sysRManager;
  Q: accessQ;
begin
  receive initArgs from initQ;
  sysRM := initArgs.rm;
  new Q;
  connect initArgs.access to Q;
  return initArgs;
  discard initQ;
  
  -- now field incoming requests
  while 'true' repeat
    block declare
      args: access;
      localRM: rManager;
      rm: rManager;
      rmList: rmList;
    begin
      receive args from Q;
      new rmList;
      -- create an empty resource manager for posted things to go into
      localRM <- personalRMFn#(create of process personalRM)
	  (args.userName);
      insert copy of localRM into rmList;
      -- chain it with the given rm, "logged in" to the caller's userName
      rm <- userRMFn#(create of process userRM)(args.userName, sysRM);
      insert rm into rmList;
      rm <- chainedRMInitFn#(create of process chainedRM)
	  (rmList,localRM);
      -- now create the process that will execute the command
      wrap rShellExecFn#(create of process rShellExec)(rm) 
	  as args.resource;
      return args;
    end block;
  end while;
end process
