-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rshelld.p
-- Author: Andy Lowry
-- SCCS Info: @(#)rshelld.p	1.3 3/11/91

-- This is the remote shell server daemon.  We post a "remote shell"
-- resource in our resource manager.  The access function creates a
-- remote shell process with a user-level resource manager logged in
-- as the user named in the get-resource message.  The process then
-- waits for the rShell message to arrive, and then invokes a pshell
-- to execute the command.

rShellD: using (rShell, rShellInt, sysMain, rManager, common) linking (rShellAC)

process (Q: sysMainQ)

declare
  args: sysMain;
  ac: accessFn;
  resource: polymorph;
  empty: empty;
begin
  receive args from Q;
  
  ac <- rShellInitFn#(create of process rShellAC)(args.rm);
  wrap empty as resource;
  call args.rm.post("system", "remote shell", resource, ac);
  
  return args;
end process
