-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rshellint.d
-- Author: Andy Lowry
-- SCCS Info: @(#)rshellint.d	1.2 3/13/90

-- internal definitions needed by the remote shell daemon

rShellInt: using (rShell, rManager, sysRManager)

definitions
  
  -- interface for process that creates remote shells
  rShellInit: callmessage (
    rm: sysRManager,		-- base system-level resource manager
    access: accessFn		-- access function that creates remote
				-- shells
  )
  constant (rm)
  exit {full};
  
  rShellInitQ: inport of rShellInit {full(rm)};
  rShellInitFn: outport of rShellInitQ;
  
  
  -- interface for a process that will field an rShell call
  rShellExec: callmessage (
    rm: rManager,
    rShell: rShellFn
  )
  constant (rm)
  exit {full};
  
  rShellExecQ: inport of rShellExec {full(rm)};
  rShellExecFn: outport of rShellExecQ;

end definitions

