-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getuses.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getuses.p	1.11 3/2/92"
-- description: 
-- getuses is passed some capabilities and returns a getuses
-- function.  This function is given the name of a Hermes source file
-- and returns a list of dependencies as determined by the module's
-- using() and linking() lists.

getuses: using (getuses,uptolow,unix,terminalio,findfile,tokenize,common,make)
linking(getnoncommentline,uptolow)

process(setupQ: setupGetusesQ)
  
declare
  setupM: setupGetusesIntf;
  fopen: fopenFn;
  getnoncommentline: getlineFunc;
  tokenize: tokenizeFn;
  tokenStrings: tokenStringsFn;
  uptolow: uptolowFn;
  getusesQ: getusesQ;
begin
  -----------------------------------------------------------------------
  ---------------------------  initialization ---------------------------
  -----------------------------------------------------------------------
  receive setupM from setupQ;
  
  fopen := setupM.fopen;
  
  getnoncommentline <- procedure of process getnoncommentline;
  block declare
    white: charstring;
  begin
    white <- " ";
    insert 'HT' into white;
    tokenize <- (tokenizeInitFn#(create of setupM.pathload("tokenize")))(
      "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_",
      white, "", "");
  end block;
  tokenStrings <- procedure of setupM.pathload("tokenstrings");
  uptolow <- procedure of process uptolow;
  
  -- create getusesFn and return callmessage
  new getusesQ;
  connect setupM.getuses to getusesQ;
  return setupM;
  
  -----------------------------------------------------------------------
  -------------------------  process requests ---------------------------
  -----------------------------------------------------------------------
  while 'true' repeat
    block declare
      getusesM: getusesIntf;
      getstring: terminalio!getStringFunc;
      file: stream;
      tokens: charstringList;
      token: charstring;
      depType: charstring;
    begin
      receive getusesM from getusesQ;
      new getusesM.uses;
      
      -- initialize getstring to be a getstring function for this file.
      -- note that we are assuming that getusesM.name give the
      -- complete path name for the file.  
      file <- fopen(getusesM.name, 'read');
      getstring := file.gets;
      -- locate the beginning of the using() list, if there is one
      new tokens;
      block begin
	while 'true' repeat
	  if size of tokens = 0 then
	    tokens <- tokenStrings(tokenize(getnoncommentline(getstring)));
	  else
	    remove token from tokens[0];
	    if token = ":" then
	      exit foundColon;
	    end if;
	  end if;
	end while;
      on exit(foundColon)
      end block;

      -- every module implicitly imports the "predefined" definitions
      -- module
      insert (evaluate d: nodeID from
	  new d;
	  d.name <- "predefined";
	  d.type <- "definitions module";
	end) into getusesM.uses;

      -- this loop will process the using list and the linking list,
      -- if found
      while 'true' repeat
	if size of tokens = 0 then
	  tokens <- tokenStrings(tokenize(getnoncommentline(getstring)));
	else
	  remove token from tokens[0];
	  call uptolow(token);
	  select token
	  where ("using")
	    depType <- "definitions module";
	  where ("linking")
	    depType <- "process module";
	  where ("process")
	    exit done;
	  where("definitions")
	    exit done;
	  otherwise
	    exit badFileFormat;
	  end select;
	  -- here we're entering a using or linking list... swallow the
	  -- initial left paren, then get all the module names on the
	  -- list and create dependencies for them.  Finish when the
	  -- right paren is seen.
	  block declare
	    state: char;
	    dep: nodeID;
	  begin
	    state <- 'S';	-- begin in start state
	    while 'true' repeat
	      if size of tokens = 0 then
		tokens <- tokenStrings(tokenize(getnoncommentline(getstring)));
	      else
		remove token from tokens[0];
		call uptolow(token);
		select state
		where ('S')	-- start statee
		  if (token = "(") then
		    state <- 'N';-- move to "name" state
		  else
		    exit badFileFormat;
		  end if;
		where ('N')	-- state looking for a name
		  if (token = ")") then -- empty list
		    exit doneList;
		  end if;
		  new dep;
		  dep.name := token;
		  dep.type := depType;
		  block begin
		    insert dep into getusesM.uses;
		  on (duplicateKey)
		  end block;
		  state <- ',';	-- look for comma next
		where (',')	-- look for a comma or right paren
		  select token[0]
		  where (',')
		    state <- 'N';
		  where (')')
		    exit doneList;
		  otherwise
		    exit badFileFormat;
		  end select;
		otherwise
		  exit badFileFormat;
		end select;
	      end if;
	    end while;
	  on exit(doneList)
	  end block;
	end if;
      end while;
      exit done;

    on exit(done)
      -- all done;
      call file.fclose();
      return getusesM;
      
    on (getLineIntf.endOfInput)
      -- didn't make it to the "process" or "definitions" token in the
      -- source file...
      return getusesM exception getusesFailure;

    on exit (badFileFormat)
      -- some other syntax error detected
      return getusesM exception getusesfailure;
      
    end block;
    
  end while;
  
on (disconnected)
end process
