-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initloadfuncs.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initloadfuncs.p	1.4 1/20/92"
-- description:
-- initFindfileFuncs is given some capabilities and returns 4 findfile
--  functions; they locate a return a file relative to a unix path.  
initloadfuncs: using(initloadfuncs,root,initfindfile,findfile)
process(q: initloadfuncsQ)

declare
  cm: initloadfuncsIntf; 
  enventry: root!enventry;
  sourcepath: charstring;	-- search path for source files
  defpath: charstring;		-- search path for definitions modules
  procpath: charstring;		-- search path for linked process modules
  initFindFile: initfindfile!initFindFileFn;
begin
  receive cm from q;
  initFindFile <- procedure of cm.pathload("findfile");
  block begin
    enventry <- cm.environ["HPATH"];
    defpath <- enventry.value;
  on (NotFound)
    enventry <- cm.environ["HROOTDIR"];
    defpath <- ".:" | enventry.value | "/bin" ;
  end block;

  block begin
    enventry <- cm.environ["HSOURCEPATH"];
    sourcepath <- enventry.value;
  on (NotFound)
    sourcepath := defpath;
  end block;
  
  block begin
    enventry <- cm.environ["HLINKPATH"];
    procpath <- enventry.value;
  on (NotFound)
    block begin
      enventry <- cm.environ["HLOADPATH"];
      procpath <- enventry.value;
    on (NotFound)
      procpath := defpath;
    end block;
  end block;

  cm.findfilePO <- initFindFile(cm.access, cm.getCwd, procpath);
  cm.findfileDO <- initFindFile(cm.access, cm.getCwd, defpath);
  cm.findfilePsrc <- initFindFile(cm.access, cm.getCwd, sourcepath);
  cm.findfileDsrc := cm.findfilePsrc;
  cm.findfileTarget := cm.findfilePsrc;
  return cm;
end process
