-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pcomshell.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)pcomshell.p	1.7 3/2/92"
-- recieves a process name + env and returns the function to invoke pcom on that name
pcomshell: using(make,getdep,terminalIO,rManager,load,main,common)
process(ActionInitQ: ActionInitq)

declare
  ActionInitArgs: ActionInitIntf;
  args: ActionIntf;
  pathLoad: load_func;
  pcom: main!mainFn;
  argv: charstringList;
  rm: rManager;
  terminal: terminalFunctions;
  q: ActionQ;
  fn: ActionFunc;
begin
  receive ActionInitArgs from ActionInitQ;
  unwrap pathLoad from ActionInitArgs.rm.get("pathLoad", "") {init};

  new argv; 

  -- insert the command line into the arguments list  (hermes pcom <name>)i
  insert "hermes" into argv;  
  insert "pcom" into argv;
  insert copy of ActionInitArgs.name into argv; 
  terminal := ActionInitArgs.terminal;
  rm := ActionInitArgs.rm;
  
  new q;
  connect fn to q;
  ActionInitArgs.action <- fn;
  return ActionInitArgs;

  -- wait for call 
  receive args from q;
  pcom <- create of pathLoad("pcom");
  block begin
    call pcom(argv,terminal,rm);
    args.made <- 'true';	-- compilation success
  on (Disconnected)		-- if pcom bombs out
    args.made <- 'false';	-- compilation failure
  end block;

  return args;
on (disconnected)
  -- target wasn't re-made
end process
