-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)shell.p	1.8 6/14/91

-- Hermes shell.  Runs programs with the main!main_intf interface.  The prompt
-- may be set by use of the HPROMPT environment variable; it defaults to 
-- "shell: ".  Additionally, the commands "cd", "pwd", and "exit" are 
-- supported directly.
--
-- David F. Bacon, 1 June 1989

shell: using (predefined, main, common, tokenize, terminalIO,
  rManager, load, root, cwd)
process (initQ: mainQ)

declare
  init: main;
  compiler: mainFn;
  input: charstring;
  command: charstring;
  argv: charstringList;
  oldargv: charstringList;
  environ: root!environ;
  enventry: root!enventry;
  pathLoad: load_func;
  getCwd: getCwdFn;
  setCwd: setCwdFn;
  tokenize: tokenizeFn;
  initTokenize: tokenizeInitFn;
  tokenStrings: tokenStringsFn;
  prompt: charstring;

begin
  receive init from initQ;
  unwrap pathLoad from init.rm.get("pathLoad", "") {init};
  unwrap environ from init.rm.get("environ", "") {init};
  unwrap getCwd from init.rm.get("getCwd", "") {init};
  unwrap setCwd from init.rm.get("setCwd", "") {init};
  
  initTokenize <- create of pathload("tokenize");
  block declare
    wordChars: charString;
    whiteChars: charString;
  begin
    wordChars <- "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    wordChars <- wordChars | "1234567890!@#$%^&*_+|~-=\`;:,./?";
    whiteChars <- " ";
    insert 'HT' into whiteChars;
    tokenize <- initTokenize(wordChars, whiteChars, "'""", "(){}[]<>");
  end block;
  tokenStrings <- procedure of pathload("tokenstrings");

  block begin
    enventry <- enventry#(var in environ where (boolean#(
	var.variable = charstring#"HPROMPT")));
    prompt <- enventry.value;
  on (NotFound)
    prompt <- charstring#"shell: ";
  end block;

  while boolean#'true' repeat block begin
    call init.terminal.putString(prompt);
    input <- init.terminal.getString();
    argv <- tokenStrings(tokenize(input));
    command := charstring#(arg in argv 
	where (boolean#(integer#(position of arg) = integer#0)));
    insert charstring#"shell" into argv at integer#0;

    select command
      where (charstring#"exit")
        exit controlD;

      where (charstring#"cd")
	block
	  declare
	    path : charstring;
	    dir : charstring;
	    dirs : charstringlist;
	    i : integer;
	    D : char;
	  begin
	    dir := argv[2];
	    extract path from C in dir where(C <> ' ');
	    if exists of C in path where(position of C = 0 and C <> '/') then
		path <- getCwd() | "/" | path;
	      end if;
	    path <- path | "/";
	    new dirs;
	    while size of path <> 0 repeat
		if path[0] = '/' then
		    remove D from path[0];
		  else
		    i <- position of C in path where(C='/');
		    extract dir from C in path where(position of C < i);
		    if dir <> "." then
			if dir = ".." then
			    remove dir from dirs[size of dirs - 1];
			  else
			    insert dir into dirs;
			  end if;
		      end if;
		  end if;
	      end while;
	    if size of dirs = 0 then
		path <- "/";
	      else
		path <- "";
		while size of dirs <> 0 repeat
		    remove dir from dirs[0];
		    path <- path | "/" | dir;
		  end while;
	      end if;
	    call setCwd(path);
	  on (others)
	end block;

      where (charstring#"pwd")
	block
	  begin
	    call init.terminal.putLine(charstring#(getCwd()));
	  on (others)
	end block;

      otherwise
        block 
          declare
            main: mainFn;
          begin
	    main <- mainFn#(create of program#(
		pathload(command)));
            call main(argv, init.terminal, init.rm);

          on (load_intf.file_not_found)
	    call init.terminal.putString(charstring#"Can't find '");
	    call init.terminal.putString(command);
	    call init.terminal.putLine(charstring#"'.");
          on (load_intf.CantLoadProgram)
	    call init.terminal.putString(charstring#"Can't load '");
	    call init.terminal.putString(command);
	    call init.terminal.putLine(charstring#"'.");
          on (InterfaceMismatch)
	    call init.terminal.putString(charstring#"Module '");
	    call init.terminal.putString(command);
	    call init.terminal.putLine(charstring#"' is not a main program.");
	  on (main.discarded)
	    -- just a rude main process... we can't be bothered!
          on (others)
	    call init.terminal.putString(charstring#"Can't run '");
	    call init.terminal.putString(command);
	    call init.terminal.putLine(charstring#"' -- reason unknown.");
        end block;
            
    end select;

  on (getStringIntf.endOfInput)
    exit controlD;
  on (tokenize.illFormed)
    call init.terminal.putLine("Invalid command syntax");
  on (notFound)
    -- user entered a null command; do nothing.
  end block; end while;

  return init;

on exit (controlD)
  call init.terminal.putLine(charstring#"^D");
  return init;

end process
