-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)string.p	1.4 3/13/90 
-- checks that the argument is a string type, i.e. an ordered table of
-- enumeration values
string: using(type)
PROCESS(ClassQ: ClassRuleQueue)
DECLARE
  ClassM: ClassRuleMessage;
  type: typename;

BEGIN
  RECEIVE ClassM FROM ClassQ;
  INSPECT definitions_module IN ClassM.definitions 
    	WHERE(definitions_module.id = ClassM.argument.moduleid)
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(type_def.id = ClassM.argument.typeid)
    BEGIN
      BLOCK BEGIN
	REVEAL type_def.specification.table_info;
	IF type_def.specification.table_info.ordered_table THEN 
	  -- type is element type of table
	  type := type_def.specification.table_info.element_type;
	  INSPECT defs_module IN ClassM.definitions 
		WHERE(defs_module.id = type.moduleid)
	  BEGIN
	    INSPECT t_def IN defs_module.type_definitions
		  WHERE(t_def.id = type.typeid)
	    BEGIN
	      -- type_def is type definition of element type
	      REVEAL t_def.specification.enumeration;
	      ClassM.result <- 'true';   -- it is a string
	    END INSPECT;
	  END INSPECT;
	ELSE ClassM.result <- 'false';  -- it isn't a string (not ordered)
	END IF;
      ON (CaseError) 
	-- the argument is not a table type or its elementtype is not
	-- an enumeration type
	ClassM.result <- 'false';
      END BLOCK;
    END INSPECT;
  END INSPECT;
  RETURN ClassM;
END process
