-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: type.bs
-- Author: Dan Yellin
-- SCCS Info: @(#)componentsoverlap.p	1.3 3/13/90

-- componentsoverlap is a function that takes two ordered tables of 
-- componentid.  It returns true if the components overlap; i.e., if
-- one table is a ``subtable'' of the other.  Otherwise the function
-- returns false.  

componentsoverlap: using(type)
process(Q: componentsOverlapQueue)

declare
  args: componentsOverlapIntf;
  c2: componentid;
begin

  receive args from Q;

  -- if they agree on all components up to the shorter length then
  -- return true. Otherwise return false
  for c1 in args.comp1[] inspect
    block begin
      c2 := componentid#(c in args.comp2 where 
	    (boolean#(integer#(position of c) = integer#(position of c1))));
    on (notFound)
      exit overlap;
    end block;
    if boolean#(c1 <> c2) then
      exit noOverlap;
    end if;
  end for;

  exit overlap;

on exit(overlap)
  args.result <- boolean#'true';  
  return args;

on exit(noOverlap)
  args.result <- boolean#'false';
  return args;

end process
