-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: beginaltern.p
-- Author: Rob Strom
-- SCCS Info: @(#)beginaltern.p	1.1 7/27/89

-- Function: Check alternative clauses with common branch point.  Return exit TS.
-- Algorithm:
-- 1. Create JoinTS initially never branched.
-- 2. For each new alternative, check the clause, and if there is a normal
--    exit from the clause, GLB the exit TS with the join TS.
-- 3. At end of alternatives, exit NoNormalExit if there is a join TS,
--    else generate the softcoercions, and return the join TS
beginaltern : USING( Predefined, tscheck, Coercions  ) PROCESS ( BeginAlternativesInit : BeginAlternativesInport )
  DECLARE
    NextAlternativeIn: NextAlternativeInport;
    EndAlternativesIn: EndAlternativesInport;
    NullAlternativeIn: NullAlternativeInport;
  BEGIN
    BLOCK
      DECLARE
        FP: BeginAlternativesCall;
      BEGIN
        RECEIVE FP From BeginAlternativesInit;
        NEW NextAlternativeIn;
        NEW EndAlternativesIn;
        NEW NullAlternativeIn;
        CONNECT FP.NextAlternative TO NextAlternativeIn;
        CONNECT FP.EndAlternatives TO EndAlternativesIn;
        CONNECT FP.NullAlternative TO NullAlternativeIn;
        RETURN FP;
      END BLOCK;
    BLOCK
      DECLARE
        JoinTS: OptCoercionInfo;
        Nothing: Empty;
     BEGIN
        UNITE JoinTS.NeverBranched FROM Nothing;
        WHILE ('true')
          REPEAT
            SELECT
              EVENT NextAlternativeIn
                BLOCK
                  DECLARE
                    FP: NextAlternativeCall;
                    ExitTS: Typestate; -- typestate returned from normal exit
                  BEGIN
                    RECEIVE FP From NextAlternativeIn;
                    CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, FP.Clause, FP.EntryTS, ExitTS, FP.Context);
                    CALL FP.Services.SoftGLB(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, ExitTS, CONVERT OF SIZE OF FP.Context.Scopes - 1, JoinTS);
                    RETURN FP;
                  ON (CheckClauseCall.NoNormalExit)
                    RETURN FP;
                  END BLOCK;
                  
              EVENT NullAlternativeIn
                BLOCK
                  DECLARE
                    FP: NullAlternativeCall;
                    ExitTS: Typestate; -- typestate returned from normal exit
                  BEGIN
                    RECEIVE FP From NullAlternativeIn;
		    ExitTS := FP.EntryTS;
		    CALL FP.Services.SoftGLB(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, ExitTS, CONVERT OF SIZE OF FP.Context.Scopes - 1, JoinTS);
                    RETURN FP;
                  END BLOCK;

              EVENT EndAlternativesIn
                BLOCK
                  DECLARE
                    FP: EndAlternativesCall;
                    JoinInfo: CoercionInfo;
                    Coercion: Coercion;
                  BEGIN
                    RECEIVE FP FROM EndAlternativesIn;
                    REVEAL JoinTS.Branched;
--                  DISSOLVE JoinTS.Branched INTO JoinInfo;
                    JoinInfo := JoinTS.Branched;
                    FP.ExitTS <- JoinInfo.TargetTS;
--                  /* debug */ CALL FP.Services.Outside.Terminal.PutLine("AlternativeDrops:"|FP.Services.Debug.FormatTypestate(FP.Services.Debug, FP.Definitions,  FP.Code.Scopes, FP.Context.InferredDcls, FP.Context.DefinitionsMap, FP.Context.ExecutableMap, JoinInfo.Drops));
                    NEW Coercion;
                    Coercion.Position := FP.Position;
                    Coercion.Coercions <- FP.Services.SoftCoerce(FP.Services, FP.Code.Scopes, FP.Context, FP.Definitions, JoinInfo.Drops);
                    INSERT Coercion INTO FP.Context.PostCoercions; 
                    RETURN FP;
                  ON (CaseError)
                    RETURN FP EXCEPTION NoNormalExit;
                  END BLOCK;
                EXIT Done;
             OTHERWISE -- should not occur
             END SELECT;
          END WHILE;
      ON EXIT(Done)
      END BLOCK;
  END PROCESS
