-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkguardc.p
-- Author: Rob Strom
-- SCCS Info: @(#)checkguardc.p	1.4 2/5/92

-- Function: Check that a clause which is supposed to generate
--    a boolean result terminates and generates an INIT boolean result
-- Algorithm:
-- 1. Check the clause
-- 2. Complain if the clause has no normal exit
-- 3. Require typestate INIT(RESULT), and APPLY PRECONDITION
checkguardc : USING( Predefined, tscheck, Errors) PROCESS ( CheckGuardClauseInit : CheckGuardClauseInport )
  DECLARE
    FP: CheckGuardClauseCall;
  BEGIN
    RECEIVE FP From CheckGuardClauseInit;
    BLOCK
      BEGIN
	CALL FP.Services.CheckClause(FP.Services, FP.Code, FP.Definitions, FP.Clause, FP.EntryTS, FP.ExitTS, FP.Context);
	CALL FP.Services.ApplyPrecondition(FP.Services, FP.Code.Scopes, FP.Definitions, FP.Position, FP.Context, (EVALUATE InitResultTS: Typestate FROM
	  NEW InitResultTS;
	  INSERT (EVALUATE InitResult: Attribute FROM
	    NEW InitResult;
	    UNITE InitResult.Name.Init FROM (EVALUATE Nothing: Empty FROM END);
	    NEW InitResult.Objects;
	    INSERT COPY OF FP.Result INTO InitResult.Objects;
	    END) INTO InitResultTS;
	  END), (EVALUATE EmptyTS: Typestate FROM NEW EmptyTS; END), FP.ExitTS);
        RETURN FP;
      ON (CheckClauseCall.NoNormalExit)
        INSERT (EVALUATE ErrorMessage: Error FROM
          NEW ErrorMessage;
          UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
          ErrorMessage.Code <- 'DeadCode';
          NEW ErrorMessage.Objects;
	  INSERT (EVALUATE ErrorObject: ErrorObject FROM
	      UNITE ErrorObject.Charstring FROM "IF/WHILE/WHERE guard expression does not terminate"; END)
	        INTO ErrorMessage.Objects;
	  END) INTO FP.Context.ErrorMessages;
        RETURN FP Exception NoNormalExit;
      END BLOCK;
  END PROCESS
