-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomakeunin.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomakeunin.p	1.4 3/13/90

pomakeunin : USING( tscheck, Predefined  ) PROCESS (PostMakeUninitInit : DeterminePostconditionInport )
-- Compute Postcondition of Discard
-- Algorithm:
-- 1. For each attribute involving source object, 
--    put that attribute in the Drops list
-- 2. Include INIT(object), even if not in TS
--    (Reason: If INIT(object) is implicitly in TS, then
--    the appropriate typestate error will occur.
--    If it is illegal to drop any involved attribute,
--    it will also be illegal to drop INIT(object).)
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    AttributesInvolvingSource : Typestate;
    AttributeInvolvingSource: Attribute;
    EmptyAttributeList:  Typestate;
  BEGIN
    RECEIVE FP FROM PostMakeUninitInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
	-- 1.
	NEW EmptyAttributeList; 
	CALL FP.Services.Involving(FP.CurrentTS, SourceObject, EmptyAttributeList, AttributesInvolvingSource);
--      MERGE AttributesInvolvingSource INTO FP.NormalPostcondition.Drops;
        BLOCK
          BEGIN
            WHILE('true')
              REPEAT
                REMOVE AttributeInvolvingSource FROM A IN AttributesInvolvingSource WHERE('true');
                INSERT AttributeInvolvingSource INTO FP.NormalPostcondition.Drops;
              END WHILE;
          ON (NotFound)
          END BLOCK;
        BLOCK 
          BEGIN
	    INSERT EVALUATE InitSource: Attribute FROM
	      NEW InitSource;
	      NEW InitSource.Objects;
	      UNITE InitSource.Name.Init FROM EVALUATE Empty: Empty FROM END;
	      INSERT COPY OF SourceObject INTO InitSource.Objects;
	    END INTO FP.NormalPostcondition.Drops;
	  ON(DuplicateKey)
	  END BLOCK;
--	/* debug */ CALL FP.Services.Outside.Terminal.PutLine(FP.Services.Debug.FormatTypestate(FP.Services.Debug, FP.Definitions, FP.Declarations, FP.Context.InferredDcls, FP.Context.DefinitionsMap, FP.Context.ExecutableMap, FP.NormalPostcondition.Drops)); 
--	/* debug */ CALL FP.Services.Outside.Terminal.PutLine("Merged");
      END INSPECT;
    RETURN FP;
  END PROCESS
