-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: precasets.p
-- Author: Rob Strom
-- SCCS Info: @(#)precasets.p	1.3 12/19/91

-- precasets:  Precondition for UNITE and DISSOLVE
-- Algorithm:
-- 1. Split V.X object into V and X
-- 2. Get case formal typestate of V.X
-- 3. Substitute OBJ.  This will be the required TS
-- *4. Attributes Involving Obj will be the forbidden TS
-- Modified 12/18/91: don't do step 4.
precasets : USING( tscheck, Predefined ) PROCESS ( CheckVarInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
    V: Objectname; -- the variant
    X: ComponentId; -- the component
    VType: Typename; -- the variant's type
    CaseTypestate: Typestate; -- the case typestate
    HigherAttributes: Typestate; -- additional attributes above case typestate
    
  BEGIN
    RECEIVE FP FROM CheckVarInit ;
    INSPECT Obj IN FP.Statement.Operands WHERE(POSITION OF Obj = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        V <- Object IN FP.Statement.Operands WHERE(POSITION OF Object = Offset in FP.Affected_Operands WHERE(POSITION OF Offset = 1));
        REMOVE X FROM Component IN V.Components WHERE(POSITION OF Component = SIZE OF V.Components - 1);
        Vtype <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, V);
	INSPECT Module IN FP.Definitions WHERE(Module.Id = VType.ModuleId)
	  BEGIN
	    INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = VType.TypeId)
	      BEGIN
		-- 2, 3.
		REVEAL Definition.Specification.Variant_Info; 
		INSPECT Mapping IN Definition.Specification.Variant_Info.Case_Mapping WHERE(Mapping.Component_Id = X)
		  BEGIN
		    CALL FP.Services.Substitute(FP.Services, Obj, Mapping.Case_Typestate, CaseTypestate);
		  END INSPECT;
		-- 4.
		MERGE CaseTypestate INTO FP.Required;
	      END INSPECT;
	  END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
