-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: prepos.p
-- Author: Rob Strom
-- SCCS Info: @(#)prepos.p	1.3 3/13/90

-- prepos:  Procedure to determine whether an object name is Pos
-- perform checkvar on selected object number

prepos : USING( tscheck, errors )
  PROCESS ( CheckPosInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
  BEGIN
    RECEIVE FP FROM CheckPosInit ;
    INSPECT Object IN FP.Statement.Operands WHERE(boolean # (integer # (POSITION OF Object) = integer # (Offset IN FP.Affected_Operands WHERE(boolean # (integer # (POSITION OF Offset) = integer # (0))))))
      BEGIN
        IF EXISTS OF Rootname IN FP.Context.Pos WHERE(Rootname = Object.Root)
          THEN
          ELSE
	    /* GenerateErrorMessage */ BLOCK
	      DECLARE
		ErrorMessage: Error;
		ErrorObject: ErrorObject;
	      BEGIN
		NEW ErrorMessage;
		UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
		ErrorMessage.Code <- errorcode # 'Position';
		NEW ErrorMessage.Objects;
		UNITE ErrorObject.Objectname FROM Objectname # (COPY OF Object);
		INSERT ErrorObject INTO ErrorMessage.Objects;
		INSERT ErrorMessage INTO FP.Context.ErrorMessages;   
	      END BLOCK /* GenerateErrorMessage */;            
          END IF;
      END INSPECT;
    RETURN FP;
  END PROCESS
