-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: typestate.p
-- Author: Rob Strom
-- SCCS Info: @(#)typestate.p	1.10 2/5/92

typestate: using (predefined, common, main, filedef, absformat, typestate,
  inferredtype, interpform, loadProg, typecheck, errors, checking_table,
  Typestate_Inference, tscheck, objectIO, coercions, posmap)
  linking(tscc, tsapre, tsapost, tsatc, involving, exceptionbr, checkguardc,
  beginaltern, softglb, softcoerce, impliedat, checkloop, checkvar,
  tstypeof, substobject, substcparms, pocall, prenull, ponull,
  precall, preinit, prepos, prevar, prechecked, precasets, preinsert, prereturn,
  prereveal, presend, prewrap, prerangeerr, preuncopy, predupkey,
  pomakeinit, pocopyts, pomakeunin, pomvts, podissolve, pohide, pokill,
  pomakechecked, pomakecheckeddefinitions, 
  pomventts, pomvelts, pomakecase, popolyts, pomakefull)
  process ( initport: TypestateCheckInport )

declare
  init: TypestateCheckCall;
  filename: charstring;
  filedef: filed_definition;
  arbobj: polymorph;
  li_code: interpform!prog;
  infdefs: InferredDefinitions;
  infdefs_temp: InferredDefinitions;
  loadProg: loadProgFunc; -- absprog loader
  badModule: charstring;
  defMaps: definitions_printmappings;
  procMaps: executable_printmappings;
  notyet: DeterminePreconditionOutport; -- null precondition for stuff under test
  notyetp: DeterminePostconditionOutport; -- null postcondition
  typecheck_c: TypeCheckCapa; -- typechecker
  errors: errors;
  poly: polymorph;
  checking_table: checking_table; -- table of rules for TC and TSC
  Services: TypestateCheckingServices; -- Programs Needed By Phases
  Context: TypestateCheckingEnvironment; -- Data Needed by TSC
  CurrentTypestate: Typestate; -- Typestate computed by TSC
  ExitTS: Typestate; -- typestate on exit (ignored now)

begin 
  receive init from initport;
-- Load the debugging environment
  NEW Services;
  Services.Outside := Init.StdEnv;
  Services.Checking_Table := Init.Checking_Table;
  Services.Debug <- (getFormattersOutport#(create of
	  init.stdEnv.pathLoad("getformatters")))();

    Services.CheckClause <- PROCEDURE OF process tscc;
    Services.ApplyPrecondition <- PROCEDURE OF process tsapre;
    Services.ApplyPostcondition <- PROCEDURE OF process tsapost;
    Services.AttemptToCoerce <- PROCEDURE OF process tsatc;
    Services.Involving <- PROCEDURE OF process involving;
    Services.ExceptionBranch <- PROCEDURE OF process exceptionbr;
    Services.CheckGuardClause <- PROCEDURE OF process checkguardc;
    Services.BeginAlternatives <- PROCEDURE OF process beginaltern;
    Services.SoftGLB <- PROCEDURE OF process softglb;
    Services.SoftCoerce <- PROCEDURE OF process softcoerce;
    Services.ImpliedAttribute <- PROCEDURE OF process impliedat;
    Services.CheckLoop <- PROCEDURE OF process checkloop;
    Services.CheckVar <- PROCEDURE OF process checkvar;
    Services.TypeOf <- PROCEDURE OF process tstypeof;
    Services.Substitute <- PROCEDURE OF process substobject;
    Services.SubstituteCallParameters <- PROCEDURE OF process substcparms;
    Services.DetermineCallPostcondition <- PROCEDURE OF process pocall;


-- read in typestate checking functions
  NEW Services.PreconditionFunctions;
  NEW Services.PostconditionRegularFunctions;
  notyet <- PROCEDURE OF process prenull;
  notyetp <- PROCEDURE OF process ponull;
  INSERT (EVALUATE L1: LabelledPreconditionFunction FROM
    NEW L1;
    L1.Name <-  'callpreconditions';
    L1.Function <- PROCEDURE OF process precall;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L2: LabelledPreconditionFunction FROM
    NEW L2;
    L2.Name <-  'init';
    L2.Function <- PROCEDURE OF process preinit;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L3: LabelledPreconditionFunction FROM
    NEW L3;
    L3.Name <-  'pos';
    L3.Function := PROCEDURE OF process prepos;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L3a: LabelledPreconditionFunction FROM
    NEW L3a;
    L3a.Name <-  'var';
    L3a.Function <- PROCEDURE OF process prevar;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L4: LabelledPreconditionFunction FROM
    NEW L4;
    L4.Name <-  'assertable';
    L4.Function := notyet;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L5: LabelledPreconditionFunction FROM
    NEW L5;
    L5.Name <-  'full';
    L5.Function := notyet;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L6: LabelledPreconditionFunction FROM
    NEW L6;
    L6.Name <-  'checked';
    L6.Function <- PROCEDURE OF process prechecked;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L7: LabelledPreconditionFunction FROM
    NEW L7;
    L7.Name <-  'casets';
    L7.Function := PROCEDURE OF process precasets;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L8: LabelledPreconditionFunction FROM
    NEW L8;
    L8.Name <-  'lowestelementstate';
    L8.Function := PROCEDURE OF process preinsert;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L9: LabelledPreconditionFunction FROM
    NEW L9;
    L9.Name <-  'lowestpostcondition';
    L9.Function := PROCEDURE OF process prereturn;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L10: LabelledPreconditionFunction FROM
    NEW L10;
    L10.Name <-  'initwithoutcase';
    L10.Function := PROCEDURE OF process prereveal;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L11: LabelledPreconditionFunction FROM
    NEW L11;
    L11.Name <-  'lowestentrycondition';
    L11.Function := PROCEDURE OF process presend;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L12: LabelledPreconditionFunction FROM
    NEW L12;
    L12.Name <-  'polymorphprecondition';
    L12.Function := PROCEDURE OF process prewrap;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L13: LabelledPreconditionFunction FROM
    NEW L13;
    L13.Name <-  'rangeerror?';
    L13.Function := PROCEDURE OF process prerangeerr;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L14: LabelledPreconditionFunction FROM
    NEW L14;
    L14.Name <-  'uncopyable?';
    L14.Function := PROCEDURE OF process preuncopy;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L15: LabelledPreconditionFunction FROM
    NEW L15;
    L15.Name <-  'duplicatekey?';
    L15.Function := PROCEDURE OF process predupkey;
    END) INTO Services.PreconditionFunctions;
  INSERT (EVALUATE L16: LabelledPostconditionFunction FROM
    NEW L16;
    L16.Name <-  'makeinit';
    L16.Function <- PROCEDURE OF process pomakeinit;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L17: LabelledPostconditionFunction FROM
    NEW L17;
    L17.Name <-  'asserted';
    L17.Function := notyetp;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L18: LabelledPostconditionFunction FROM
    NEW L18;
    L18.Name <-  'makechecked';
    L18.Function := PROCEDURE OF process pomakechecked;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L18B: LabelledPostconditionFunction FROM
    NEW L18B;
    L18B.Name <-  'makecheckeddefinitions';
    L18B.Function := PROCEDURE OF process pomakecheckeddefinitions;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L19: LabelledPostconditionFunction FROM
    NEW L19;
    L19.Name <-  'copy';
    L19.Function <- PROCEDURE OF process pocopyts;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L20: LabelledPostconditionFunction FROM
    NEW L20;
    L20.Name <-  'makeuninit';
    L20.Function <- PROCEDURE OF process pomakeunin;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L21: LabelledPostconditionFunction FROM
    NEW L21;
    L21.Name <-  'movets';
    L21.Function <- PROCEDURE OF process pomvts;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L22: LabelledPostconditionFunction FROM
    NEW L22;
    L22.Name <-  'killvariant';
    L22.Function <- PROCEDURE OF process podissolve;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L23: LabelledPostconditionFunction FROM
    NEW L23;
    L23.Name <-  'dropcomponents';
    L23.Function <- PROCEDURE OF process pohide;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L24: LabelledPostconditionFunction FROM
    NEW L24;
    L24.Name <-  'killconstraints';
    L24.Function := PROCEDURE OF process pokill;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L25: LabelledPostconditionFunction FROM
    NEW L25;
    L25.Name <-  'moveentryts';
    L25.Function <- PROCEDURE OF process pomventts;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L26: LabelledPostconditionFunction FROM
    NEW L26;
    L26.Name <-  'moveelementts';
    L26.Function <- PROCEDURE OF process pomvelts;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L27: LabelledPostconditionFunction FROM
    NEW L27;
    L27.Name <-  'makecase';
    L27.Function <- PROCEDURE OF process pomakecase;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L28: LabelledPostconditionFunction FROM
    NEW L28;
    L28.Name <-  'polymorphts';
    L28.Function := PROCEDURE OF process popolyts;
    END) INTO Services.PostconditionRegularFunctions;
  INSERT (EVALUATE L29: LabelledPostconditionFunction FROM
    NEW L29;
    L29.Name <-  'makefull';
    L29.Function := PROCEDURE OF process pomakefull;
    END) INTO Services.PostconditionRegularFunctions;

block
declare
  proc: proc; -- process being typestate checked
 begin  
  New init.Coercions;
  NEW Context;
  Context.DefinitionsMap := init.DefinitionsMaps;
  Context.InferredDcls := init.InferredDefinitions;
  
  proc := init.proc;
  -- 2.1. Begin with empty context, and only INIT(initport)
      
  NEW Context.Scopes;
  NEW Context.ExpressionBlocks;
  NEW Context.HandlerScopes;
  NEW Context.Constants;
  NEW Context.Inspecting;
  NEW Context.Pos;
  NEW Context.PreCoercions;
  NEW Context.PostCoercions;
  NEW Context.HandlerCoercions;
  NEW Context.OuterOthers;
  NEW Context.ErrorMessages;
  block begin
      Context.ExecutableMap <- Map IN init.ExecutableMap 
         WHERE(EVALUATE t: Boolean FROM
              BLOCK
                BEGIN
                  REVEAL Map.Id.Pid;
                  t <- Map.Id.Pid = Proc.Id;
                ON (CaseError)
                  t <- 'false';
                END BLOCK;
            END);
    on (notfound)
      -- make bogus executableMap
      new Context.ExecutableMap;
      unite Context.ExecutableMap.id.pid
         from evaluate p: processid from
          p <- unique;
        end;
      Context.ExecutableMap.name <- "bogus";
      new Context.ExecutableMap.roots;
      new Context.ExecutableMap.exits;
    end block;

  NEW CurrentTypestate;
  INSERT (EVALUATE InitIport : Attribute FROM
          NEW InitIport;
          UNITE InitIport.Name.Init FROM EVALUATE Empty: Empty FROM END;
          NEW InitIport.Objects;
          INSERT (EVALUATE IportName : ObjectName FROM
                  NEW IportName;
                  NEW IportName.Root;
                  IportName.Root.Root := Proc.Initport;
                  IportName.Root.Scope := Proc.Executable_Part.Main_Scope;
                  NEW IportName.Components;
                END) INTO InitIport.Objects;
        END) INTO CurrentTypestate;
  
  INSPECT MainScope IN Proc.Executable_Part.Scopes WHERE(MainScope.Id = Proc.Executable_Part.Main_Scope)
	BEGIN
	  INSERT COPY OF MainScope.Id INTO Context.Scopes;
	  CALL Services.CheckClause(Services, Proc.Executable_Part, init.program.Definitions_Modules, MainScope.Clause, CurrentTypestate, ExitTS, Context);
	END INSPECT;
	
  IF SIZE OF Context.ErrorMessages > 0
    THEN
    ELSE
      INSERT EVALUATE ProcessCoercions: ProcessCoercions FROM
          NEW ProcessCoercions;
          ProcessCoercions.Id := Proc.Id;
          ProcessCoercions.PreCoercions := Context.PreCoercions;
          ProcessCoercions.PostCoercions := Context.PostCoercions;
          NEW ProcessCoercions.HandlerCoercions;
          FOR SoftCoercion IN Context.HandlerCoercions[]
            INSPECT
              BLOCK
                BEGIN
                  REVEAL SoftCoercion.Dataflow.Branched;
                  --                  /* debug */ CALL Services.Outside.Terminal.PutLine("HandlerDrops:"|Services.Debug.FormatTypestate(Services.Debug, init.program.Definitions_Modules,  Proc.Executable_Part.Scopes, Context.InferredDcls, Context.DefinitionsMap, Context.ExecutableMap, SoftCoercion.Dataflow.Branched.Drops));
                  INSERT EVALUATE ClauseCoercion: ClauseCoercion FROM
                      NEW ClauseCoercion;
                      ClauseCoercion.Clause := SoftCoercion.ClauseId;
                      ClauseCoercion.Coercions <- Services.SoftCoerce(Services, Proc.Executable_Part.Scopes, Context, init.program.Definitions_Modules, COPY OF SoftCoercion.Dataflow.Branched.Drops);
                    END INTO ProcessCoercions.HandlerCoercions;
                ON(CaseError)
                END BLOCK;
            END FOR;
        END INTO Init.Coercions;
    END IF;

  init.errormessages <- context.errormessages;
  IF SIZE OF init.errormessages = 0 THEN
      RETURN init;
    ELSE
      RETURN init EXCEPTION TypestateErrors;
    END IF;
on (duplicatekey)
  print charstring#"dup key in main block typestate.p";
on (others)
  print charstring#"others exception in main block of typestate.p";
    
end block;

  
on (InterfaceMismatch)
  call Services.Outside.terminal.putLine(charstring#"Interfacing problems in typestate.p.");
   
  discard init;
on(others)
  print charstring # "Unexpected error in typestate.p";
  
end process
