-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.

Adapter:  using(Standard, Adapter, WMExternal, Quit)
process(Init: AdapterIn)
  declare
    Parms: AdapterInterface; -- initialization callmessage
    Put: PutLineIn; -- PutLine service
    Get: GetProgramIn; -- GetProgram service
    Quit: QuitIn; -- Quit service
    Window: WriteToWindowOut; -- access to window
    GetProgramOut:  GetProgramOut;  -- access to GetProgram service
    WindowName: Charstring; -- name of window
    Running: boolean; -- true if process has not been shut down
    GetProgramCM: GetProgramInterface;
    PutCM: PutLineInterface;
    QuitCM: QuitInterface;
  begin
    -- initialization
    receive Parms from Init;
    new Put; connect Parms.ClientPutLine to Put;
    new Get; connect Parms.ClientGetProgram to Get;
    new Quit; connect Parms.Quit to Quit;
    Window := Parms.AdapterToWindow;
    GetProgramOut := Parms.GetProgram;
    WindowName := Parms.WindowName;
    Running := 'true';
    return Parms;
    
    --  service loop
    while (Running) repeat
      select
      
        event Put
          receive PutCM from Put;
          call Window(WindowName, PutCM.Line );
          return PutCM;
          
        event Get
          receive GetProgramCM from Get;
          call GetProgramOut(GetProgramCM.Name,
            GetProgramCM.TheProgram);
          return GetProgramCM;
          
        event Quit
          receive QuitCM from Quit;
          Running := 'false';
          return QuitCM;
          
        otherwise -- should not occur
        end select;
      end while;
    end process
    
