-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- a tutorial front end to run the bounded buffer
bbintf :  using(main,string, stdenv,bbexternal, quit,standard, load)
  linking(atoi,itoa)
process(Init: mainQ)
declare
  cm: main;
  atoi:string2intFn;
  itoa:int2stringFn;
  BBcapacity:integer;
  Put:PutLineOut;
  Get:GetLineOut;
  Quit:QuitOut;
  bb:BBOut;
  line:charstring;
  errormsg:charstring;
  cmd:char;
  space:char;
  pathLoad: load_func;
begin
  receive cm from init;
  unwrap pathLoad from cm.rm.get("pathLoad", "") {init};
  
  -- front end for the bounded buffer
  -- bounder buffer provides the services put, get and quit:
  -- line formats:
  -- P <rest of line>   put <rest of line> to bounded buffer
  -- G              get a line from bounded buffer and print it
  -- Q              quit, shutting down bounded buffer
  
  -- start up bounded buffer, optional capacity as an argument
  -- repeatedly get lines from the terminal
  -- select on first character
  
  
  bb := create of pathLoad( cm.argv[2] );
  BBcapacity := 3;   -- default
  if (size of cm.argv > 3)
  then
    block begin
      atoi := create of process atoi;
      BBcapacity := atoi(cm.argv[3]);
    on (string2int.badFormat)
      call cm.terminal.putLine( cm.argv[3] | " not an integer.");
    end block;
  end if;
  itoa := create of process itoa;
  call cm.terminal.putLine( "Initializing "| cm.argv[2] | " with capacity " |itoa( BBcapacity ) | ".");
  call bb( BBcapacity, Put, Get, Quit);
  
  block begin
    while 'true' repeat
      call cm.terminal.putString("bbintf prompt: "  );
      call cm.terminal.getString( line );
      if (size of Line > 0)
      then
        remove cmd from Line[0];
        select (cmd)
        
          where ('P')
          remove space from Line[0];
            call cm.terminal.putLine( "Putting `" | Line | "' into bounded buffer.");
            -- this will deadlock if the bounded buffer is full
            call Put(Line);
            
          where ('G')
            -- this will deadlock if the bounded buffer is empty
            Line := Get();
            call cm.terminal.putLine( "Getting `"|Line| "' from bounded buffer.");
          where ('Q')
            call cm.terminal.putLine( "Quitting bounded buffer." );
            call Quit();
            exit quitting;
            
          otherwise
            errormsg :=  "Unknown bbintf command: ";
            insert cmd into errormsg;
            call cm.terminal.putLine( errormsg );
          end select;
        end if;
      end while;
    on exit (quitting)
    end block;
    
    return cm;
  end process
