-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
frontend : using(tokenizer,standard, fepexternal , WMExternal) linking ( )
process( Init : FEPIn)

declare
  Parms:FEPInterface;
  WindowName:Charstring; -- window currently in focus
  tokenizer: TokenizeOut; -- procedure to remove a token from a string
  running:boolean; -- true if process has not been quit by user
begin
-- EXAMPLE_TYPE STATEMENTS

  running := 'true';
  receive Parms from Init;
  tokenizer := procedure of Parms.GetProgram("tokenizer");
  WindowName := ""; -- no window in focus
  block begin
  
    while (running) repeat
    
      block declare
        Line: Charstring; -- line read by frontend
        Escape: Char; -- escape character removed from line
      begin
        call Parms.PutLine( WindowName | ">"); -- prompt user
        call Parms.GetLine(Line);
        if size of Line = 0
          then
            call Parms.Dispatch(WindowName, Line);
          else if Line[0] <> '!'
          then
            call Parms.Dispatch(WindowName, Line);
          else
            remove Escape from Line[0];
            block declare
              Cmd: Charstring; -- command name following !
            begin
              if Line[0] = '!'
              then
                call Parms.Dispatch(WindowName, Line);
              else
                extract cmd from Line[0];
                select (cmd)
                
                  where("F") -- Refocus command
                    block declare
                      FParm: Charstring; -- parameter to !F
                    begin
                      FParm := tokenizer(Line);
                      call Parms.Refocus(FParm);
                      call Parms.PutLine( "!wfe: Focus changed to "
                          | FParm | ".");
                      WindowName := FParm;
                    on ( WindowInterface.NotFound)
                      call Parms.PutLine("!wfe:" | FParm |
                          " not a window.");
                    end block;
                    
                  where("K") -- Kill a window
                    block declare
                      KParm: Charstring; -- parameter to !K
                    begin
                      KParm := tokenizer(Line);
                      call Parms.Kill(Kparm);
                      call Parms.PutLine(  Kparm | " killed.");
                    on ( WindowInterface.NotFound)
                      call Parms.PutLine("!wfe:" | Kparm |
                          " not a window.");
                    end block;
                    
                  where("Q") -- Quit command
                    running := 'false';
                    call Parms.PutLine( "Quitting window manager.");
                    
                  where("C") -- Create a window
                    block declare
                      CParm: Charstring; -- window parameter to !C
                      PName: Charstring; -- program name
                      Parm: Charstring; -- program parameters
                    begin
                      CParm := tokenizer(Line);
                      PName := tokenizer(Line);
                      Parm := Line;
                      call Parms.Create(Cparm, Pname, Parm);
                      WindowName := CParm;
                    on ( CreateInterface.Duplicate)
                      call Parms.PutLine("!wfe: Cannot create window "|
                        CParm | " since it already exists." );
                    on ( CreateInterface.CreateFailure)
                      call Parms.PutLine("!wfe: Cannot create process "
                        | PName | ".");
                    end block;
                  otherwise
                    -- error: not F, Q, K or C
                    call Parms.PutLine("!wfe: Illegal command: " | cmd);
                  end select;
                end if;
                
              on (TokenizeInterface.noToken)
              -- error
                call Parms.PutLine(  "!wfe: Missing argument.");
              end block;
            end if; end if;
            
        on (DispatchInterface.NotFound)
          call Parms.PutLine( "!wfe: Window " | WindowName |
            " does not exist");
        end block;
        
      end while;
    on (others)
      call Parms.PutLine(  "!wfe: others exception");
    end block;
  return Parms;
  
end process
