-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- a little process that creates a standard interface for tutorial example processes
stdfilter :  using(stdfilter,load,main,stdenv,standard,terminalio)
process(Init: stdfilter_In)
declare
  CM: stdfilter_intf;
  getString_CM:GetLineInterface;
  putLine_CM:PutLineInterface;
  getProgram_CM:GetProgramInterface;
  
  getString_for_tut_proc:GetLineIn;
  putLine_for_tut_proc:PutLineIn;
  getProgram_for_tut_proc:GetProgramIn;
  
  getString_used_by_tut_procFn:GetLineOut;
  putLine_used_by_tut_procFn:PutLineOut;
  getProgram_used_by_tut_procFn:GetProgramOut;
  
  getString : getStringFunc;
  putLine : putStringFunc;
  Load: load_func;
  
begin
  receive cm from init;
  
  new getString_for_tut_proc;
  new putLine_for_tut_proc;
  new getProgram_for_tut_proc;
  
  connect cm.getString_used_by_tut_procFn to getString_for_tut_proc;
  connect cm.putLine_used_by_tut_procFn to putLine_for_tut_proc;
  connect cm.getProgram_used_by_tut_procFn to getProgram_for_tut_proc;
  
  -- copy main capabilities
  getString := copy of cm.getString;
  putLine := copy of cm.putLine;
  Load := copy of cm.getProgram;
  
  return cm;
  
  -- service calls to standard intefaces
  
  while 'true' repeat
    select
    
      event getString_for_tut_proc
        block begin
          receive getString_CM from getString_for_tut_proc;
          getString_CM.Line := getString( );
          return getString_CM;
        on (getStringIntf.endOfInput)
          return  getString_CM exception EndStream;
        on (disconnected)
          print charstring # "getString raises disconnected exception";
        end block;
        
      event putLine_for_tut_proc
        block begin
          receive putLine_CM from putLine_for_tut_proc;
          call putLine( putLine_CM.Line );
          return putLine_CM;
        on (disconnected)
          print charstring # "putLine raises disconnected exception";
        end block;
        
      event getProgram_for_tut_proc
        block begin
          receive getProgram_CM from getProgram_for_tut_proc;
          getProgram_CM.TheProgram := Load( getProgram_CM.Name );
          return getProgram_CM;
        on (load_intf.file_not_found, load_intf.CantLoadProgram,
	    load_intf.discarded)  
          return  getProgram_CM exception NotFound;
        on (disconnected)
          print charstring # "Load raises disconnected exception";
        end block;
        
      otherwise
      
    end select;
  end while;
end process

