-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- a front end to make the standard interface rob wrote look real
stdintf :  using(load,stdfilter,main,stdenv,standard,terminalio)
process(Init: mainQ)
declare
  CM: main;
  tut_proc : standardOut;
  getString_CM:GetLineInterface;
  putLine_CM:PutLineInterface;
  getProgram_CM:GetProgramInterface;
  
  getString_for_tut_proc:GetLineIn;
  putLine_for_tut_proc:PutLineIn;
  getProgram_for_tut_proc:GetProgramIn;
  
  getString_used_by_tut_procFn:GetLineOut;
  putLine_used_by_tut_procFn:PutLineOut;
  getProgram_used_by_tut_procFn:GetProgramOut;
  stdfilter:stdfilter_out;
  string:charstring;
  pathLoad: load_func;
begin
  receive cm from init;
  unwrap pathLoad from cm.rm.get("pathLoad", "") {init};
  
  -- a std_filter process will make the standard interface for the tutorial process
  block begin
    stdfilter := create of (pathLoad( "stdfilter" ));
    call stdfilter(   cm.terminal.getString,
      cm.terminal.putLine,  pathLoad,
      getString_used_by_tut_procFn,
      putLine_used_by_tut_procFn,
      getProgram_used_by_tut_procFn);
      
    tut_proc := create of getProgram_used_by_tut_procFn( cm.argv[2] );
    string := "";
    -- put the arguments back into a string for the standard interface
    -- block begin
    for  argument in cm.argv where(position of argument > 2) inspect
      merge copy of argument into string;
      insert ' ' into string;
    end for;
    call tut_proc( getString_used_by_tut_procFn, putLine_used_by_tut_procFn,
      getProgram_used_by_tut_procFn, string );
  
  on (NotFound)
    call cm.terminal.putLine("no program");
  on (GetProgramInterface.NotFound)
    call cm.terminal.putString(cm.argv[2]);
    call cm.terminal.putLine(" not found");
  on (load_intf.file_not_found, load_intf.CantLoadProgram)
    call cm.terminal.putLine("no stdfilter");
  end block;
  return cm;
end process

