-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.

UnBoundedBuffer:  using(Standard, BBExternal, BBLocal, Quit)
process(Init: BBIn)
  declare
    Parms: BBInterface; -- initialization callmessage
    Put: PutLineIn; -- PutLine service
    Get: GetLineIn; -- GetLine service
    Quit: QuitIn; -- Quit service
    Queue: Lines; -- ordered set of lines
    Running: boolean; -- true if process has not been shut down
    GetCM: GetLineInterface;
    PutCM: PutLineInterface;
    QuitCM: QuitInterface;
  begin
    -- initialization
    receive Parms from Init;
    new Put; connect Parms.Put to Put;
    new Get; connect Parms.Get to Get;
    new Quit; connect Parms.Quit to Quit;
    new Queue;
    return Parms;
    
    -- service loop
    Running := 'true';
    while (Running) repeat
        select
        
          event Put
            receive PutCM from Put;
            insert copy of PutCM.Line into Queue;
            return PutCM;
            
          event Get and where(size of Queue > 0)
            receive GetCM from Get;
            remove GetCM.Line from Queue[0];
            return GetCM;
            
          event Quit
            receive QuitCM from Quit;
            Running := 'false';
            return QuitCM;
            
          otherwise -- should not occur
          end select;
      end while;
    end process
    
    
