-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.

WMExternal: using(Standard) definitions

-- initialization interface for window manager
WMInterface: callmessage (
  GetProgram: GetProgramOut, -- service for loading programs
  PutLine: PutLineOut, -- write a line to the physical terminal
  Dispatch: DispatchOut, -- dispatch a line to the appropriate window
  Refocus: WindowOut, -- change the current focus
  Kill: WindowOut, -- kill the specified window
  Create: CreateOut) -- make a new window
  constant(GetProgram, PutLine)
  exit {full};
WMIn: inport of WMInterface {init(GetProgram), init(PutLine)};
WMOut: outport of WMIn;

-- interface to operation Dispatch
DispatchInterface: callmessage (
  WindowName: Charstring, --- window to which text is being sent
  Line: Charstring) -- text to dispatch
  constant(Line)
  exit {full}
  exception NotFound {full}; -- no such window
DispatchIn: inport of DispatchInterface {full};
DispatchOut: outport of DispatchIn;

-- interface to operations Refocus, Kill
WindowInterface: callmessage (
  WindowName: Charstring) -- name of window operand
  constant(WindowName)
  exit {full}
  exception NotFound {full};
WindowIn: inport of WindowInterface {full};
WindowOut: outport of WindowIn;

-- interface to operation Create
CreateInterface: callmessage (
  WindowName: Charstring, -- name of window being created
  ProgramName: Charstring, -- name of client program to run
  ParmString: Charstring) -- parameters to client program
  constant(WindowName, ProgramName, ParmString)
  exit {full}
  exception Duplicate {full}
  exception CreateFailure {full};
CreateIn: inport of CreateInterface {full};
CreateOut: outport of CreateIn;

-- interface to operation WriteToWindow
WriteToWindowInterface: callmessage (
  WindowName: Charstring, -- name of window being output to
  Line: Charstring) -- output string
  constant(WindowName, Line)
  exit {full};
WriteToWindowIn: inport of WriteToWindowInterface {full};
WriteToWindowOut: outport of WriteToWindowIn;

end definitions

