-- (C) Copyright International Business Machines Corporation 23 January
-- 1990.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.

WMSystem:  using(Standard, WMExternal, FEPExternal)
process(Init: StandardIn)
  declare
    Parms: StandardInterface; -- initialization callmessage
    Dispatch: DispatchOut;  -- dispatch service in WM
    Refocus: WindowOut; -- refocus service in WM
    Kill: WindowOut; -- kill service in WM
    Create: CreateOut; -- create service in WM
  begin
    receive Parms from Init;
    call ( WMOut # (create of Parms.GetProgram("windowmanager")))
      (Parms.GetProgram, Parms.PutLine, Dispatch, Refocus, Kill, Create);
    call ( FEPOut # (create of Parms.GetProgram("frontend")))
      (Parms.GetLine, Parms.PutLine, Parms.GetProgram, Dispatch,
        Refocus, Kill, Create);
    return Parms;
  end process
  
  
