(in-package "C")
(export 'backend-internal-errors)
(unless (fboundp 'backend-internal-errors)
  (setf (fdefinition 'backend-internal-errors)
	#'(lambda (x)
	    (declare (ignore x))
  '#((KERNEL:UNKNOWN-ERROR . "Unknown.  System lossage.")
  (KERNEL:OBJECT-NOT-FUNCTION-ERROR . "Object is not of type FUNCTION.")
  (KERNEL:OBJECT-NOT-LIST-ERROR . "Object is not of type LIST.")
  (KERNEL:OBJECT-NOT-BIGNUM-ERROR . "Object is not of type BIGNUM.")
  (KERNEL:OBJECT-NOT-RATIO-ERROR . "Object is not of type RATIO.")
  (KERNEL:OBJECT-NOT-SINGLE-FLOAT-ERROR
   . "Object is not of type SINGLE-FLOAT.")
  (KERNEL:OBJECT-NOT-DOUBLE-FLOAT-ERROR
   . "Object is not of type DOUBLE-FLOAT.")
  (KERNEL:OBJECT-NOT-SIMPLE-STRING-ERROR
   . "Object is not of type SIMPLE-STRING.")
  (KERNEL:OBJECT-NOT-SIMPLE-BIT-VECTOR-ERROR
   . "Object is not of type SIMPLE-BIT-VECTOR.")
  (KERNEL:OBJECT-NOT-SIMPLE-VECTOR-ERROR
   . "Object is not of type SIMPLE-VECTOR.")
  (KERNEL:OBJECT-NOT-FIXNUM-ERROR . "Object is not of type FIXNUM.")
  (KERNEL:OBJECT-NOT-FUNCTION-OR-SYMBOL-ERROR
   . "Object is not of type FUNCTION or SYMBOL.")
  (KERNEL:OBJECT-NOT-VECTOR-ERROR . "Object is not of type VECTOR.")
  (KERNEL:OBJECT-NOT-STRING-ERROR . "Object is not of type STRING.")
  (KERNEL:OBJECT-NOT-BIT-VECTOR-ERROR . "Object is not of type BIT-VECTOR.")
  (KERNEL:OBJECT-NOT-ARRAY-ERROR . "Object is not of type ARRAY.")
  (KERNEL:OBJECT-NOT-NUMBER-ERROR . "Object is not of type NUMBER.")
  (KERNEL:OBJECT-NOT-RATIONAL-ERROR . "Object is not of type RATIONAL.")
  (KERNEL:OBJECT-NOT-FLOAT-ERROR . "Object is not of type FLOAT.")
  (KERNEL:OBJECT-NOT-REAL-ERROR . "Object is not of type REAL.")
  (KERNEL:OBJECT-NOT-INTEGER-ERROR . "Object is not of type INTEGER.")
  (KERNEL:OBJECT-NOT-CONS-ERROR . "Object is not of type CONS.")
  (KERNEL:OBJECT-NOT-SYMBOL-ERROR . "Object is not of type SYMBOL.")
  (KERNEL:UNDEFINED-SYMBOL-ERROR . "Undefined symbol.")
  (KERNEL:OBJECT-NOT-COERCABLE-TO-FUNCTION-ERROR
   . "Object is not coercable to type FUNCTION.")
  (KERNEL:INVALID-ARGUMENT-COUNT-ERROR . "Invalid argument count.")
  (KERNEL:BOGUS-ARGUMENT-TO-VALUES-LIST-ERROR
   . "Bogus argument to VALUES-LIST.")
  (KERNEL:UNBOUND-SYMBOL-ERROR . "Unbound symbol.") (NIL . "unused")
  (KERNEL:OBJECT-NOT-SAP-ERROR . "Object is not a System Area Pointer (SAP).")
  (KERNEL:INVALID-UNWIND-ERROR
   . "Attempt to RETURN-FROM a block that no longer exists.")
  (KERNEL:UNSEEN-THROW-TAG-ERROR . "Attempt to THROW to a non-existent tag.")
  (KERNEL:DIVISION-BY-ZERO-ERROR . "Attempt to divide by zero.")
  (KERNEL:OBJECT-NOT-TYPE-ERROR . "Object is of the wrong type.")
  (KERNEL:ODD-KEYWORD-ARGUMENTS-ERROR . "Odd number of keyword arguments.")
  (KERNEL:UNKNOWN-KEYWORD-ARGUMENT-ERROR . "Unknown keyword.") (NIL . "unused")
  (NIL . "unused") (KERNEL:INVALID-ARRAY-INDEX-ERROR . "Invalid array index.")
  (KERNEL:WRONG-NUMBER-OF-INDICES-ERROR . "Wrong number of indices.")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-ERROR
   . "Object is not of type SIMPLE-ARRAY.")
  (KERNEL:OBJECT-NOT-SIGNED-BYTE-32-ERROR
   . "Object is not of type (SIGNED-BYTE 32).")
  (KERNEL:OBJECT-NOT-UNSIGNED-BYTE-32-ERROR
   . "Object is not of type (UNSIGNED-BYTE 32).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-2-ERROR
   . "Object is not of type (SIMPLE-ARRAY (UNSIGNED-BYTE 2) (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-4-ERROR
   . "Object is not of type (SIMPLE-ARRAY (UNSIGNED-BYTE 4) (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-8-ERROR
   . "Object is not of type (SIMPLE-ARRAY (UNSIGNED-BYTE 8) (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-16-ERROR
   . "Object is not of type (SIMPLE-ARRAY (UNSIGNED-BYTE 16) (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-32-ERROR
   . "Object is not of type (SIMPLE-ARRAY (UNSIGNED-BYTE 32) (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-SINGLE-FLOAT-ERROR
   . "Object is not of type (SIMPLE-ARRAY SINGLE-FLOAT (*)).")
  (KERNEL:OBJECT-NOT-SIMPLE-ARRAY-DOUBLE-FLOAT-ERROR
   . "Object is not of type (SIMPLE-ARRAY DOUBLE-FLOAT (*)).")
  (KERNEL:OBJECT-NOT-COMPLEX-ERROR . "Object is not of type COMPLEX.")
  (KERNEL:OBJECT-NOT-WEAK-POINTER-ERROR . "Object is not a WEAK-POINTER.")
  (KERNEL:OBJECT-NOT-STRUCTURE-ERROR . "Object is not a STRUCTURE.")
  (KERNEL:OBJECT-NOT-BASE-CHAR-ERROR . "Object is not of type BASE-CHAR.")
  (KERNEL:NIL-FUNCTION-RETURNED-ERROR
   . "Function with declared result type NIL returned.")))))

(in-package "KERNEL")
(export '(fdefn fdefn-p))
(in-package "VM")

;;; ### Hack...
(def-source-transform fdefn-p (x) (declare (ignore x)) 'nil)

#+sparc
(set 'sparc::NUMBER-STACK-DISPLACEMENT 64)

#+(and sparc sunos)
(load "target:c-call")

(in-package "EXT")
(export '*herald-items*)
(defvar *herald-items* nil)
