functor MLLexFun
	   (structure Tokens : ML_TOKENS
            structure Ascii :ASCII
            structure ErrorMsg :ERRORMSG
            structure LexStuff :LEXSTUFF
              sharing LexStuff.ErrorMsg = ErrorMsg
              sharing type LexStuff.pos = ErrorMsg.pos = int
              sharing type Tokens.token = LexStuff.token
              sharing type Tokens.svalue = LexStuff.svalue
           )=
   struct
    structure UserDeclarations =
      struct
(* Copyright 1989 by AT&T Bell Laboratories *)
open ErrorMsg LexStuff
type svalue = Tokens.svalue
type pos = int
type lexresult = (svalue,pos) Tokens.token
type lexarg = {comLevel : int ref, 
	       lineNum : int ref,
	       linePos : int list ref, (* offsets of lines in file *)
		charlist : string list ref,
		stringstart : int ref, (* start of current string or comment*)
	       err : pos*pos -> ErrorMsg.severity -> string->unit}
type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token
val eof = fn ({comLevel,err,linePos,stringstart,lineNum,charlist}:lexarg) => 
	   let val pos = Integer.max(!stringstart+2, hd(!linePos))
	    in if !comLevel>0 then err (!stringstart,pos) COMPLAIN
					 "unclosed comment" 
		  	      else ();
	       Tokens.EOF(pos,pos)
	   end	
fun addString (charlist,s:string) = charlist := s :: (!charlist)
fun makeString charlist = (implode(rev(!charlist)) before charlist := nil)
fun makeHexInt sign s = let
      fun digit d = if (d < Ascii.uc_a) then (d - Ascii.zero)
	    else (10 + (if (d < Ascii.lc_a) then (d - Ascii.uc_a) else (d - Ascii.lc_a)))
      in
	revfold (fn (c,a) => sign(a*16, digit(ord c))) (explode s) 0
      end
fun makeInt sign s =
    revfold (fn (c,a) => sign(a*10, ord c - Ascii.zero)) (explode s) 0
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\010\010\010\010\010\010\010\010\010\140\142\010\140\010\010\010\
\\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\
\\140\118\139\118\118\118\118\137\135\134\132\118\131\129\128\118\
\\124\122\122\122\122\122\122\122\122\122\121\120\118\119\118\118\
\\118\020\020\020\020\020\020\020\020\020\020\020\020\020\020\020\
\\020\020\020\020\020\020\020\020\020\020\020\010\118\010\118\020\
\\118\115\020\020\107\091\084\020\020\068\020\020\063\020\057\052\
\\020\020\020\029\025\020\022\020\020\020\020\019\018\017\011\010\
\\009"
val s3 =
"\143\143\143\143\143\143\143\143\143\143\148\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\146\143\144\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\143\
\\143"
val s5 =
"\149\149\149\149\149\149\149\149\149\149\163\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\162\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\150\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149"
val s7 =
"\164\164\164\164\164\164\164\164\164\166\168\164\166\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\166\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\165\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\164\
\\164"
val s11 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\000\012\012\000\012\000\012\
\\014\013\013\013\013\013\013\013\013\013\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\000\012\012\000\012\000\012\
\\000\000\000\000\000\000\000\000\000\000\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\016\016\016\016\016\016\016\016\016\016\000\000\000\000\000\000\
\\000\016\016\016\016\016\016\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\016\016\016\016\016\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\023\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\024\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s25 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\026\021\000\000\000\000\000\
\\000"
val s26 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\027\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\028\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\046\038\021\021\021\021\021\021\
\\021\021\021\021\030\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s30 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\031\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s31 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\032\021\021\021\021\021\000\000\000\000\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\033\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s33 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\034\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s34 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\035\021\021\021\021\021\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\036\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\037\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s38 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\039\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\040\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\041\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s41 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\042\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\043\021\021\021\021\021\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\044\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\045\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\047\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\048\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\049\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\050\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\051\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s52 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\056\021\021\021\021\021\021\021\021\021\
\\053\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\054\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\055\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\058\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\059\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\060\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\061\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s61 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\062\021\021\000\000\000\000\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\064\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\065\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s65 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\066\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\067\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s68 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\079\069\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s69 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\074\021\021\070\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s70 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\071\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s71 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\072\021\021\000\000\000\000\000\
\\000"
val s72 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\073\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s74 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\075\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s75 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\076\021\021\021\021\021\000\000\000\000\000\
\\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\077\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s77 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\078\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s79 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\080\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s80 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\081\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s81 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\082\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s82 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\083\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s84 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\085\021\021\021\021\021\000\000\000\000\000\
\\000"
val s85 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\086\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s86 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\087\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s87 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\088\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s88 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\089\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s89 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\090\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s91 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\105\021\
\\021\100\021\021\021\021\021\021\092\021\021\000\000\000\000\000\
\\000"
val s92 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\093\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s93 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\094\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s94 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\095\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s95 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\096\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s96 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\097\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s97 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\098\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s98 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\099\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s100 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\101\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s101 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\102\021\000\000\000\000\000\
\\000"
val s102 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\103\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s103 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\104\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s105 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\106\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s107 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\108\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s108 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\109\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s109 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\110\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s110 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\111\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s111 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\112\021\000\000\000\000\000\
\\000"
val s112 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\113\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s113 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\114\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s115 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\116\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s116 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\021\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\117\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
val s122 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\123\123\123\123\123\123\123\123\123\123\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s124 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\127\127\127\127\127\127\127\127\127\127\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\125\000\000\000\000\000\000\000\
\\000"
val s125 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\126\126\126\126\126\126\126\126\126\126\000\000\000\000\000\000\
\\000\126\126\126\126\126\126\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\126\126\126\126\126\126\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s127 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\127\127\127\127\127\127\127\127\127\127\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s129 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\000\012\012\000\012\000\012\
\\000\000\000\000\000\000\000\000\000\000\012\000\012\012\130\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s132 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\133\012\012\000\012\000\012\
\\000\000\000\000\000\000\000\000\000\000\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s135 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\136\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s137 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\138\000\000\000\000\000\000\000\000\
\\138\138\138\138\138\138\138\138\138\138\000\000\000\000\000\000\
\\000\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\000\000\000\000\138\
\\000\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\000\000\000\000\000\
\\000"
val s140 =
"\000\000\000\000\000\000\000\000\000\141\000\000\141\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\141\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s144 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\145\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s146 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\147\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s149 =
"\149\149\149\149\149\149\149\149\149\149\000\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\000\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\000\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\149\
\\149"
val s150 =
"\000\000\000\000\000\000\000\000\000\160\161\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\160\000\159\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\156\156\156\156\156\156\156\156\156\156\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\155\000\153\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\152\000\
\\000\000\000\000\151\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s153 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\
\\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s156 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\157\157\157\157\157\157\157\157\157\157\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s157 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\158\158\158\158\158\158\158\158\158\158\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s166 =
"\000\000\000\000\000\000\000\000\000\167\000\000\167\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\167\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [(N 2)], trans = s1},
{fin = [(N 2)], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 230)], trans = s5},
{fin = [(N 230)], trans = s5},
{fin = [(N 241)], trans = s7},
{fin = [(N 241)], trans = s7},
{fin = [(N 212),(N 214)], trans = s0},
{fin = [(N 214)], trans = s0},
{fin = [(N 181),(N 214)], trans = s11},
{fin = [(N 181)], trans = s12},
{fin = [(N 191)], trans = s13},
{fin = [(N 191)], trans = s14},
{fin = [], trans = s15},
{fin = [(N 202)], trans = s15},
{fin = [(N 18),(N 214)], trans = s0},
{fin = [(N 8),(N 181),(N 214)], trans = s12},
{fin = [(N 16),(N 214)], trans = s0},
{fin = [(N 181),(N 214)], trans = s20},
{fin = [(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s22},
{fin = [(N 181)], trans = s23},
{fin = [(N 160),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s25},
{fin = [(N 181)], trans = s26},
{fin = [(N 181)], trans = s27},
{fin = [(N 156),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s29},
{fin = [(N 181)], trans = s30},
{fin = [(N 181)], trans = s31},
{fin = [(N 181)], trans = s32},
{fin = [(N 181)], trans = s33},
{fin = [(N 181)], trans = s34},
{fin = [(N 181)], trans = s35},
{fin = [(N 181)], trans = s36},
{fin = [(N 151),(N 181)], trans = s20},
{fin = [(N 181)], trans = s38},
{fin = [(N 131),(N 181)], trans = s39},
{fin = [(N 181)], trans = s40},
{fin = [(N 181)], trans = s41},
{fin = [(N 181)], trans = s42},
{fin = [(N 181)], trans = s43},
{fin = [(N 181)], trans = s44},
{fin = [(N 141),(N 181)], trans = s20},
{fin = [(N 181)], trans = s46},
{fin = [(N 181)], trans = s47},
{fin = [(N 181)], trans = s48},
{fin = [(N 181)], trans = s49},
{fin = [(N 181)], trans = s50},
{fin = [(N 127),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s52},
{fin = [(N 114),(N 181)], trans = s53},
{fin = [(N 181)], trans = s54},
{fin = [(N 119),(N 181)], trans = s20},
{fin = [(N 111),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s57},
{fin = [(N 181)], trans = s58},
{fin = [(N 181)], trans = s59},
{fin = [(N 181)], trans = s60},
{fin = [(N 181)], trans = s61},
{fin = [(N 108),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s63},
{fin = [(N 181)], trans = s64},
{fin = [(N 181)], trans = s65},
{fin = [(N 181)], trans = s66},
{fin = [(N 101),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s68},
{fin = [(N 74),(N 181)], trans = s69},
{fin = [(N 181)], trans = s70},
{fin = [(N 181)], trans = s71},
{fin = [(N 88),(N 181)], trans = s72},
{fin = [(N 95),(N 181)], trans = s20},
{fin = [(N 181)], trans = s74},
{fin = [(N 181)], trans = s75},
{fin = [(N 181)], trans = s76},
{fin = [(N 181)], trans = s77},
{fin = [(N 82),(N 181)], trans = s20},
{fin = [(N 181)], trans = s79},
{fin = [(N 181)], trans = s80},
{fin = [(N 181)], trans = s81},
{fin = [(N 181)], trans = s82},
{fin = [(N 167),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s84},
{fin = [(N 181)], trans = s85},
{fin = [(N 181)], trans = s86},
{fin = [(N 181)], trans = s87},
{fin = [(N 181)], trans = s88},
{fin = [(N 181)], trans = s89},
{fin = [(N 71),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s91},
{fin = [(N 181)], trans = s92},
{fin = [(N 181)], trans = s93},
{fin = [(N 181)], trans = s94},
{fin = [(N 181)], trans = s95},
{fin = [(N 181)], trans = s96},
{fin = [(N 181)], trans = s97},
{fin = [(N 181)], trans = s98},
{fin = [(N 63),(N 181)], trans = s20},
{fin = [(N 181)], trans = s100},
{fin = [(N 181)], trans = s101},
{fin = [(N 181)], trans = s102},
{fin = [(N 181)], trans = s103},
{fin = [(N 53),(N 181)], trans = s20},
{fin = [(N 181)], trans = s105},
{fin = [(N 46),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s107},
{fin = [(N 181)], trans = s108},
{fin = [(N 181)], trans = s109},
{fin = [(N 181)], trans = s110},
{fin = [(N 181)], trans = s111},
{fin = [(N 181)], trans = s112},
{fin = [(N 181)], trans = s113},
{fin = [(N 40),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s115},
{fin = [(N 181)], trans = s116},
{fin = [(N 28),(N 181)], trans = s20},
{fin = [(N 181),(N 214)], trans = s12},
{fin = [(N 12),(N 181),(N 214)], trans = s12},
{fin = [(N 20),(N 214)], trans = s0},
{fin = [(N 10),(N 181),(N 214)], trans = s12},
{fin = [(N 184),(N 187),(N 214)], trans = s122},
{fin = [(N 184),(N 187)], trans = s122},
{fin = [(N 187),(N 214)], trans = s124},
{fin = [], trans = s125},
{fin = [(N 196)], trans = s125},
{fin = [(N 187)], trans = s127},
{fin = [(N 42),(N 214)], trans = s0},
{fin = [(N 181),(N 214)], trans = s129},
{fin = [(N 31),(N 181)], trans = s12},
{fin = [(N 14),(N 214)], trans = s0},
{fin = [(N 6),(N 181),(N 214)], trans = s132},
{fin = [(N 210)], trans = s0},
{fin = [(N 24),(N 214)], trans = s0},
{fin = [(N 22),(N 214)], trans = s135},
{fin = [(N 207)], trans = s0},
{fin = [(N 170),(N 181),(N 214)], trans = s137},
{fin = [(N 170),(N 181)], trans = s137},
{fin = [(N 204),(N 214)], trans = s0},
{fin = [(N 2),(N 214)], trans = s140},
{fin = [(N 2)], trans = s140},
{fin = [(N 4)], trans = s0},
{fin = [(N 224)], trans = s0},
{fin = [(N 224)], trans = s144},
{fin = [(N 222)], trans = s0},
{fin = [(N 224)], trans = s146},
{fin = [(N 217)], trans = s0},
{fin = [(N 219)], trans = s0},
{fin = [(N 230)], trans = s149},
{fin = [(N 268)], trans = s150},
{fin = [(N 248)], trans = s0},
{fin = [(N 251)], trans = s0},
{fin = [], trans = s153},
{fin = [(N 261)], trans = s0},
{fin = [(N 254)], trans = s0},
{fin = [], trans = s156},
{fin = [], trans = s157},
{fin = [(N 266)], trans = s0},
{fin = [(N 257)], trans = s0},
{fin = [(N 236)], trans = s0},
{fin = [(N 233)], trans = s0},
{fin = [(N 226)], trans = s0},
{fin = [(N 228)], trans = s0},
{fin = [(N 245)], trans = s0},
{fin = [(N 243),(N 245)], trans = s0},
{fin = [(N 241),(N 245)], trans = s166},
{fin = [(N 241)], trans = s166},
{fin = [(N 238)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as ({comLevel,lineNum,err,linePos,charlist,stringstart})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  10 => (Tokens.COLON(yypos,yypos+1))
| 101 => (Tokens.LOCAL(yypos,yypos+5))
| 108 => (Tokens.NONFIX(yypos,yypos+6))
| 111 => (Tokens.OF(yypos,yypos+2))
| 114 => (Tokens.OP(yypos,yypos+2))
| 119 => (Tokens.OPEN(yypos,yypos+4))
| 12 => (Tokens.EQUAL(yypos,yypos+1))
| 127 => (Tokens.SHARING(yypos,yypos+7))
| 131 => (Tokens.SIG(yypos,yypos+3))
| 14 => (Tokens.COMMA(yypos,yypos+1))
| 141 => (Tokens.SIGNATURE(yypos,yypos+9))
| 151 => (Tokens.STRUCTURE(yypos,yypos+9))
| 156 => (Tokens.TYPE(yypos,yypos+4))
| 16 => (Tokens.LBRACE(yypos,yypos+1))
| 160 => (Tokens.VAL(yypos,yypos+3))
| 167 => (Tokens.IMPORT(yypos,yypos+6))
| 170 => (Tokens.TYVAR(yytext, yypos, yypos+size yytext))
| 18 => (Tokens.RBRACE(yypos,yypos+1))
| 181 => (Tokens.ID(yytext, yypos, yypos+size yytext))
| 184 => (Tokens.INT(makeInt (op +) yytext
		    handle Overflow => (err (yypos,yypos+size yytext)
					  COMPLAIN "integer too large"; 1),
			yypos,yypos+size yytext))
| 187 => (Tokens.INT0(makeInt (op +) yytext
		    handle Overflow => (err (yypos,yypos+size yytext)
					  COMPLAIN "integer too large"; 0),
			yypos,yypos+size yytext))
| 191 => (Tokens.INT0(makeInt (op -)
					(substring(yytext,1,size(yytext)-1))
		    handle Overflow => (err (yypos,yypos+size yytext)
					 COMPLAIN "integer too large"; 0),
			yypos,yypos+size yytext))
| 196 => (
		    Tokens.INT0(makeHexInt (op +) (substring(yytext, 2, size(yytext)-2))
		        handle Overflow => (err (yypos,yypos+size yytext)
					    COMPLAIN "integer too large"; 0),
		      yypos, yypos+size yytext))
| 2 => (continue())
| 20 => (Tokens.SEMICOLON(yypos,yypos+1))
| 202 => (
		    Tokens.INT0(makeHexInt (op -) (substring(yytext, 3, size(yytext)-3))
		        handle Overflow => (err (yypos,yypos+size yytext)
					    COMPLAIN "integer too large"; 0),
		      yypos, yypos+size yytext))
| 204 => (charlist := [""]; stringstart := yypos;
			YYBEGIN S; continue())
| 207 => (YYBEGIN A; stringstart := yypos; comLevel := 1; continue())
| 210 => (err(yypos,yypos+1) COMPLAIN "unmatched close comment"; continue())
| 212 => (err (yypos,yypos) COMPLAIN "non-Ascii character"; continue())
| 214 => (err (yypos,yypos) COMPLAIN "illegal token"; continue())
| 217 => (inc comLevel; continue())
| 219 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 22 => (Tokens.LPAREN(yypos,yypos+1))
| 222 => (dec comLevel; if !comLevel=0 then YYBEGIN INITIAL else (); continue())
| 224 => (continue())
| 226 => (YYBEGIN INITIAL; Tokens.STRING(makeString charlist,
				!stringstart,yypos+1))
| 228 => (err (!stringstart,yypos) COMPLAIN "unclosed string";
		    inc lineNum; linePos := yypos :: !linePos;
		    YYBEGIN INITIAL; Tokens.STRING(makeString charlist,!stringstart,yypos))
| 230 => (addString(charlist,yytext); continue())
| 233 => (inc lineNum; linePos := yypos :: !linePos;
		    YYBEGIN F; continue())
| 236 => (YYBEGIN F; continue())
| 238 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 24 => (Tokens.RPAREN(yypos,yypos+1))
| 241 => (continue())
| 243 => (YYBEGIN S; stringstart := yypos; continue())
| 245 => (err (!stringstart,yypos) COMPLAIN "unclosed string"; 
		    YYBEGIN INITIAL; Tokens.STRING(makeString charlist,!stringstart,yypos+1))
| 248 => (addString(charlist,"\t"); continue())
| 251 => (addString(charlist,"\n"); continue())
| 254 => (addString(charlist,"\\"); continue())
| 257 => (addString(charlist,chr(Ascii.dquote)); continue())
| 261 => (addString(charlist,chr(ordof(yytext,2)-ord("@"))); continue())
| 266 => (let val x = ordof(yytext,1)*100
	     +ordof(yytext,2)*10
	     +ordof(yytext,3)
	     -(Ascii.zero*111)
  in (if x>255
      then err (yypos,yypos+4) COMPLAIN "illegal ascii escape"
      else addString(charlist,chr x);
      continue())
  end)
| 268 => (err (yypos,yypos+1) COMPLAIN "illegal string escape"; 
		    continue())
| 28 => (Tokens.AND(yypos,yypos+3))
| 31 => (Tokens.ARROW(yypos,yypos+2))
| 4 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 40 => (Tokens.DATATYPE(yypos,yypos+8))
| 42 => (Tokens.DOT(yypos,yypos+1))
| 46 => (Tokens.END(yypos,yypos+3))
| 53 => (Tokens.EQTYPE(yypos,yypos+6))
| 6 => (Tokens.ASTERISK(yypos,yypos+1))
| 63 => (Tokens.EXCEPTION(yypos,yypos+9))
| 71 => (Tokens.FUNCTOR(yypos,yypos+7))
| 74 => (Tokens.IN(yypos,yypos+2))
| 8 => (Tokens.BAR(yypos,yypos+1))
| 82 => (Tokens.INCLUDE(yypos,yypos+7))
| 88 => (Tokens.INFIX(yypos,yypos+5))
| 95 => (Tokens.INFIXR(yypos,yypos+6))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves) else
	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
