(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Ord.m3                                                *)
(* Last Modified On Tue Jun 30 08:54:35 PDT 1992 By kalsow     *)
(*      Modified On Sat Dec  8 00:54:19 1990 By muller         *)

MODULE Ord;

IMPORT CallExpr, Expr, Type, Procedure, Int, Error;
IMPORT IntegerExpr, EnumExpr, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  VAR t: Type.T;
  BEGIN
    t := Expr.TypeOf (args[0]);
    IF (Type.Number (t) < 0) THEN
      Error.Msg ("ORD: argument must be an ordinal");
    END;
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  BEGIN
    RETURN Expr.Compile (args[0]);
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e: Expr.T; i: INTEGER; t: Type.T;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF (e = NIL) THEN
      RETURN NIL;
    ELSIF EnumExpr.Split (e, i, t) THEN
      RETURN IntegerExpr.New (i);
    ELSIF IntegerExpr.Split (e, i) THEN
      RETURN IntegerExpr.New (i);
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("ORD", Z, TRUE);
  END Initialize;

BEGIN
END Ord.
